<?php

/*******************************/
/* Site Navigation
/******************************/
if(!function_exists('softing_nav_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_nav_integrateWithVC' );
function softing_nav_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Navigation', 'softing' ),
	'base' 	   => 'softing_nav',
	'icon'      => 'icon_menu',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Menu type', 'softing' ),
		'param_name'	=> 'mtype',
		'description'	=> esc_html__('You can select theme primary menu or custom menu', 'softing' ),
		'value'			=> array(
			esc_html__('Select a menu', 'softing' )	=> '',
			esc_html__('Primary menu', 'softing' )	=> 'primary',
			esc_html__('Custom menu', 'softing' )=> 'custom',
		),
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Menu style', 'softing' ),
		'param_name'	=> 'mstyle',
		'description'	=> esc_html__('You can select theme primary menu or custom menu', 'softing' ),
		'value'			=> array(
			esc_html__('Select a menu style', 'softing' )	=> '',
			esc_html__('normal background', 'softing' )	=> 'normal',
			esc_html__('Transparent menu', 'softing' )=> 'trans',
			esc_html__('Fixed menu no background', 'softing' )=> 'fixed',
		),
		),
		//loop features
		array(
		'type'			=> 'param_group',
		'heading'		=> esc_html__('Create custom menu', 'softing' ),
		'param_name'	=> 'cmenu',
		'params'		=> array(
			array(
			'type'			=> 'vc_link',
			'heading'		=> esc_html__('Menu item title and link', 'softing'),
			'param_name'	=> 'link',
			'edit_field_class' => 'vc_col-sm-9 pt15'
			),
			array(
			'type'          => 'checkbox',
			'heading'       => esc_html__('Add Submenu?', 'softing' ),
			'param_name'    => 'submenu',
			'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
			'edit_field_class' => 'vc_col-sm-3'
			),
			array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__('Submenu', 'softing' ),
			'param_name'	=> 'subloop',
			'params'		=> array(
				array(
				'type'			=> 'vc_link',
				'heading'		=> esc_html__('Submenu title and link', 'softing'),
				'param_name'	=> 'slink',
				),
			),
			'dependency' 	=> array(
				'element' 	=> 'submenu',
				'not_empty' => true
			)
			)
		),
		'dependency' 	=> array(
			'element' 	=> 'mtype',
			'value' 	=> 'custom'
		),
		),
		//logo
		array(
		'type'			=> 'attach_image',
		'heading'		=> esc_html__('Logo', 'softing'),
		'description'	=> esc_html__('Upload image logo.', 'softing'),
		'param_name'	=> 'logo',
		'group' 		=> esc_html__( 'Logo', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6 pt15',
		),
		array(
		'type'			=> 'attach_image',
		'heading'		=> esc_html__('Logo 2', 'softing'),
		'description'	=> esc_html__('Upload second image logo for transparent menu.', 'softing'),
		'param_name'	=> 'logo2',
		'group' 		=> esc_html__( 'Logo', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6',
		),
		//right section button
		array(
		'type'			=> 'vc_link',
		'heading'		=> esc_html__('Menu first button', 'softing'),
		'param_name'	=> 'btn1',
		'group' 		=> esc_html__( 'Buttons', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6 pt15'
		),
		array(
		'type'			=> 'vc_link',
		'heading'		=> esc_html__('Menu second button', 'softing'),
		'param_name'	=> 'btn2',
		'group' 		=> esc_html__( 'Buttons', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		//custom style
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Menu background', 'softing'),
		'param_name'	=> 'mbg',
		'edit_field_class' => 'vc_col-sm-4',
		'group' 		=> esc_html__( 'Menu Style', 'softing' ),
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Menu item', 'softing'),
		'param_name'	=> 'miclr',
		'edit_field_class' => 'vc_col-sm-4',
		'group' 		=> esc_html__( 'Menu Style', 'softing' ),
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Menu item hover color', 'softing'),
		'param_name'	=> 'mihvr',
		'edit_field_class' => 'vc_col-sm-4',
		'group' 		=> esc_html__( 'Menu Style', 'softing' ),
        ),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Button background color', 'softing'),
		'param_name'	=> 'btnbg',
		'edit_field_class' => 'vc_col-sm-2',
		'group' 		=> esc_html__( 'Button Style', 'softing' ),
        ),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Button background hover color', 'softing'),
		'param_name'	=> 'btnbghvr',
		'edit_field_class' => 'vc_col-sm-2',
		'group' 		=> esc_html__( 'Button Style', 'softing' ),
        ),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Button border color', 'softing'),
		'param_name'	=> 'btnbrdr',
		'edit_field_class' => 'vc_col-sm-2',
		'group' 		=> esc_html__( 'Button Style', 'softing' ),
        ),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Button text color', 'softing'),
		'param_name'	=> 'btnclr',
		'edit_field_class' => 'vc_col-sm-2',
		'group' 		=> esc_html__( 'Button Style', 'softing' ),
        ),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Button text hover color', 'softing'),
		'param_name'	=> 'btnhvr',
		'edit_field_class' => 'vc_col-sm-2',
		'group' 		=> esc_html__( 'Button Style', 'softing' ),
        ),
        // $btn2
        array(
        'type'			=> 'colorpicker',
        'heading'		=> esc_html__('Button background color', 'softing'),
        'param_name'	=> 'btnbg2',
        'edit_field_class' => 'vc_col-sm-2',
        'group' 		=> esc_html__( 'Button 2 Style', 'softing' ),
        ),
        array(
        'type'			=> 'colorpicker',
        'heading'		=> esc_html__('Button background hover color', 'softing'),
        'param_name'	=> 'btnbghvr2',
        'edit_field_class' => 'vc_col-sm-2',
        'group' 		=> esc_html__( 'Button 2 Style', 'softing' ),
        ),
        array(
        'type'			=> 'colorpicker',
        'heading'		=> esc_html__('Button border color', 'softing'),
        'param_name'	=> 'btnbrdr2',
        'edit_field_class' => 'vc_col-sm-2',
        'group' 		=> esc_html__( 'Button 2 Style', 'softing' ),
        ),
        array(
        'type'			=> 'colorpicker',
        'heading'		=> esc_html__('Button text color', 'softing'),
        'param_name'	=> 'btnclr2',
        'edit_field_class' => 'vc_col-sm-2',
        'group' 		=> esc_html__( 'Button 2 Style', 'softing' ),
        ),
        array(
        'type'			=> 'colorpicker',
        'heading'		=> esc_html__('Button text hover color', 'softing'),
        'param_name'	=> 'btnhvr2',
        'edit_field_class' => 'vc_col-sm-2',
        'group' 		=> esc_html__( 'Button 2 Style', 'softing' ),
        ),
	)));
}
}

/*******************************/
/* Page Breadcrumbs
/******************************/
if(!function_exists('softing_page_bread_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_page_bread_integrateWithVC' );
function softing_page_bread_integrateWithVC() {
vc_map( array(
	'name'		=> esc_html__('Page Breadcrumbs', 'softing'),
	'base'		=> 'softing_page_bread',
	'icon'		=> 'icon_map',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'	=> array(
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Page title?', 'softing' ),
		'param_name'	=> 'text',
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('Post or page title', 'softing' ) => 'post',
			esc_html__('Custom text', 'softing' ) => 'custom',
		)
		),
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Custom text', 'softing'),
		'param_name'	=> 'ctext',
		'dependency' 	=> array(
			'element' 	=> 'text',
			'value' 	=> 'custom'
		)
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Text alignment', 'softing' ),
		'param_name'	=> 'align',
		'edit_field_class' => 'vc_col-sm-3',
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('Left', 'softing' ) => 'text-left',
			esc_html__('Center', 'softing' ) => 'text-center',
			esc_html__('Right', 'softing' ) => 'text-right',
		)
		),
		//title css
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Title color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change title color.', 'softing'),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Use number in( px or unit )', 'softing'),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Use number in( px or unit )', 'softing'),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Breadcrumbs?', 'softing' ),
		'param_name'    => 'bread',
		'value' 		=> array( esc_html__( 'Hide', 'softing' ) => 'hide' ),
		'description'   => esc_html__('If checked, the page breadcrumbs text will be disabled.', 'softing' ),
		),
		//bread
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Breadcrumbs color', 'softing'),
		'param_name'	=> 'bgclr',
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'bread',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Font-size', 'softing'),
		'param_name'	=> 'bsz',
		'description'	=> esc_html__('Use number in( px or unit )', 'softing'),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'bread',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Line-height', 'softing'),
		'param_name'	=> 'blh',
		'description'	=> esc_html__('Use number in( px or unit )', 'softing'),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'bread',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Link color', 'softing'),
		'param_name'	=> 'bclr',
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'bread',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover link', 'softing'),
		'param_name'	=> 'bhvrclr',
		'description'	=> esc_html__('Change post title color.', 'softing'),
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'bread',
			'is_empty' => true
		)
		),

		//Background CSS
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		)
	)));
}
}

/*******************************/
/* Home Hero
/******************************/
if(!function_exists('softing_home_hero1_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_home_hero1_integrateWithVC' );
function softing_home_hero1_integrateWithVC() {
vc_map( array(
	'name' 	 	=> esc_html__( 'Home Hero', 'softing' ),
	'base' 	 	=> 'softing_home_hero1',
	'icon'      => 'icon_homepage',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
    'params'   => array(
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Hero banner style', 'softing' ),
		'param_name'	=> 'style',
		'value'			=> array(
			esc_html__('Select a option', 'softing' ) => '',
			esc_html__('Style 1', 'softing' ) => 'b1',
			esc_html__('Style 2', 'softing' ) => 'b2',
			esc_html__('Style 3 Carousel Slider', 'softing' ) => 'b3',
			esc_html__('Style 4', 'softing' ) => 'b4',
		)
		),
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Title', 'softing'),
		'param_name'	=> 'title',
		'description'	=> esc_html__('Add hero title.', 'softing'),
		),
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Description', 'softing'),
		'param_name'	=> 'desc',
		'description'	=> esc_html__('Add description.', 'softing'),
		),
		array(
		'type'			=> 'attach_image',
		'heading'		=> esc_html__('Banner image', 'softing'),
		'param_name'	=> 'img',
		'description'	=> esc_html__('Add banner image.', 'softing'),
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> array('b1','b2','b4'),
		)
		),
		array(
		'type'			=> 'attach_image',
		'heading'		=> esc_html__('Bottom shape svg image', 'softing'),
		'param_name'	=> 'shape',
		'description'	=> esc_html__('Add svg image to bottom banner section.', 'softing'),
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> array('b1','b4'),
		)
		),
		array(
		'type'			=> 'attach_images',
		'heading'		=> esc_html__('Slider images', 'softing'),
		'param_name'	=> 'images',
		'description'	=> esc_html__('Add description.', 'softing'),
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> array('b3'),
		)
		),
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Video URL', 'softing'),
		'param_name'	=> 'vurl',
		'description'	=> esc_html__('e.g: https://www.youtube.com/watch?v=owhuBrGIOsE', 'softing'),
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Video button title', 'softing'),
		'param_name'	=> 'vtitle',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> array('b3'),
		)
		),
		//button
		array(
		'type'          => 'vc_link',
		'heading'       => esc_html__('Button', 'softing' ),
		'param_name'    => 'link',
		'description'   => esc_html__('Add button title and link.', 'softing' ),
		'group'			=> esc_html__('Button', 'softing' ),
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Button title color', 'softing'),
		'param_name'	=> 'bclr',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover title color', 'softing'),
		'param_name'	=> 'bhvr',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Background color', 'softing'),
		'param_name'	=> 'bbg',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover background', 'softing'),
		'param_name'	=> 'bhvrbg',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Border color', 'softing'),
		'param_name'	=> 'bbrd',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover Border', 'softing'),
		'param_name'	=> 'bhvrbrd',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		//button
		array(
		'type'          => 'vc_link',
		'heading'       => esc_html__('Second Button', 'softing' ),
		'param_name'    => 'link2',
		'description'   => esc_html__('Add button title and link.', 'softing' ),
		'group'			=> esc_html__('Button', 'softing' ),
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Button title color', 'softing'),
		'param_name'	=> 'bclr2',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover title color', 'softing'),
		'param_name'	=> 'bhvr2',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Background color', 'softing'),
		'param_name'	=> 'bbg2',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover background', 'softing'),
		'param_name'	=> 'bhvrbg2',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Border color', 'softing'),
		'param_name'	=> 'bbrd2',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover Border', 'softing'),
		'param_name'	=> 'bhvrbrd2',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),

		//title
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Title color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change title text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Change title font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Change title line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		//span text
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Span title color', 'softing'),
		'param_name'	=> 'spclr',
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		//desc
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Description color', 'softing'),
		'param_name'	=> 'pclr',
		'description'	=> esc_html__('Change description text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Description font-size', 'softing'),
		'param_name'	=> 'psz',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Description line-height', 'softing'),
		'param_name'	=> 'plh',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		//info
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Video icon color', 'softing'),
		'param_name'	=> 'iclr',
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		//bg css
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Use transparent background for Row options.', 'softing' ),
		'param_name'    => 'transbg',
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' )
		),
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Box Background', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' )
    ),
		// arrays end
        array(
      'type'			=> 'dropdown',
      'heading'		=> esc_html__('Loops', 'softing' ),
      'param_name'	=> 'loops',
      'description'	=> esc_html__('let the loop begin ?', 'softing' ),
        'group'			=> esc_html__('Slider Settings', 'softing' ),
        'edit_field_class' => 'vc_col-sm-4',
          'value'			=> array(
              esc_html__('Select a option', 'softing' ) => '',
              esc_html__('Yes', 'softing' ) => 'yes',
              esc_html__('No', 'softing' ) => 'no',
          )
      ),
        array(
      'type'			=> 'dropdown',
      'heading'		=> esc_html__('Dots', 'softing' ),
      'param_name'	=> 'dotss',
      'description'	=> esc_html__('Shall we show the dots ?', 'softing' ),
        'group'			=> esc_html__('Slider Settings', 'softing' ),
        'edit_field_class' => 'vc_col-sm-4',
          'value'			=> array(
              esc_html__('Select a option', 'softing' ) => '',
              esc_html__('Yes', 'softing' ) => 'yes',
              esc_html__('No', 'softing' ) => 'no',
          )
      ),
        array(
      'type'			=> 'dropdown',
      'heading'		=> esc_html__('AutoPlay', 'softing' ),
      'param_name'	=> 'autoplays',
      'description'	=> esc_html__('let the autoplay begin ?', 'softing' ),
        'group'			=> esc_html__('Slider Settings', 'softing' ),
        'edit_field_class' => 'vc_col-sm-4',
          'value'			=> array(
              esc_html__('Select a option', 'softing' ) => '',
              esc_html__('Yes', 'softing' ) => 'yes',
              esc_html__('No', 'softing' ) => 'no',
          )
      ),
      array(
      'type'          => 'textfield',
      'heading'       => esc_html__('İtems', 'softing' ),
      'param_name'    => 'items',
      'description'	=> esc_html__('number of items you want to see on the screen', 'softing'),
      'edit_field_class' => 'vc_col-sm-4',
      'group'			=> esc_html__('Slider Settings', 'softing' )
      ),
  	)));
}
}

/*******************************/
/* Section Title
/******************************/
if(!function_exists('softing_section_title_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_section_title_integrateWithVC' );
function softing_section_title_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Section Title', 'softing' ),
	'base' 	   => 'softing_section_title',
	'icon'      => 'icon_heading',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Title', 'softing'),
		'param_name'	=> 'title',
		'description'	=> esc_html__('Add title.', 'softing'),
		),
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Description', 'softing'),
		'param_name'	=> 'desc',
		'description'	=> esc_html__('Add description item.', 'softing'),
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Text Alignment', 'softing' ),
		'param_name'	=> 'align',
		'description'	=> esc_html__('You can select text alignment', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('Left', 'softing' )	=> 'text-left',
			esc_html__('Center', 'softing' )=> 'text-center',
			esc_html__('Right', 'softing' )	=> 'text-right',
		),
		'edit_field_class' => 'vc_col-sm-6',
		),
		//title
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Title color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change title color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4 pt15'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Change title font-size. Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Change title line-height. Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		//description
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Description color', 'softing'),
		'param_name'	=> 'pclr',
		'description'	=> esc_html__('Change description color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Description font-size', 'softing'),
		'param_name'	=> 'psz',
		'description'	=> esc_html__('Change description font-size. Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Description line-height', 'softing'),
		'param_name'	=> 'plh',
		'description'	=> esc_html__('Change description line-height. Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' )
		)
      // arrays end
  	)));
}
}



/*******************************/
/* Tab Container
/******************************/
if(!function_exists('softing_tab_container_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_tab_container_integrateWithVC' );
function softing_tab_container_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Tab Container', 'softing' ),
	'base' 	   => 'softing_tab_container',
	"as_parent" 				=> array('only' => 'softing_tab_content'),
    "content_element" 			=> true,
    "show_settings_on_create"   => true,
	"js_view" 	=> 'VcColumnView',
	'icon'      => 'icon_tabcontainer',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Tab Style', 'softing' ),
		'param_name'	=> 'style',
		'description'	=> esc_html__('You can select pricing box style.', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('Style 1', 'softing' ) => 'event',
			esc_html__('Style 2', 'softing' ) => 'price',
		)
		),
		//loop features
		array(
		'type'			=> 'param_group',
		'heading'		=> esc_html__('Create tabs segment', 'softing' ),
		'param_name'	=> 'tabs',
		'params'		=> array(
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Tab ID', 'softing'),
			'param_name'	=> 'tabid',
			"admin_label"   => true,
			'description'	=> esc_html__('Enter content ID (Note: make sure it is unique and valid according to w3c specification).', 'softing')
			),
			array(
			'type'          => 'checkbox',
			'heading'       => esc_html__('Active tab?', 'softing' ),
			'param_name'    => 'active',
			"admin_label"   => true,
			'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' )
			),
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Title', 'softing'),
			'param_name'	=> 'title',
			"admin_label"   => true,
			'description'	=> esc_html__('Add tab title.', 'softing')
			),
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Date', 'softing'),
			'param_name'	=> 'date',
			'description'	=> esc_html__('Add tab date title.', 'softing'),
			'dependency' 	=> array(
				'element' 	=> 'style',
				'value'  	=> 'price'
			),
			)
		)
		), // array
		//title
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Title color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change title color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3 pt15'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Change title font-size. Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Change title line-height. Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover title color', 'softing'),
		'param_name'	=> 'thvrclr',
		'description'	=> esc_html__('Change hover title color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover tab background', 'softing'),
		'param_name'	=> 'thvrbg',
		'description'	=> esc_html__('Change hover tab background color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		//bg image
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' )
		)
      // arrays end
  	)));
}
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_softing_tab_container extends WPBakeryShortCodesContainer {}
}
}

/*******************************/
/* Tab Content
/******************************/
if(!function_exists('softing_tab_content_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_tab_content_integrateWithVC' );
function softing_tab_content_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Tab Content', 'softing' ),
	'base' 	   => 'softing_tab_content',
	"as_parent" 				=> array('except'),
	"as_child" 					=> array('only' => 'softing_tab_content'),
    "content_element" 			=> true,
    "show_settings_on_create"   => true,
	"js_view" 	=> 'VcColumnView',
	'icon'      => 'icon_tabcontent',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Tab ID', 'softing'),
		'param_name'	=> 'tabid',
		"admin_label"   => true,
		'description'	=> esc_html__('Add tab title.', 'softing'),
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Active content?', 'softing' ),
		'param_name'    => 'active',
		"admin_label"   => true,
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
		),
		//bg image
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		),
      // arrays end
  	)));
}
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_softing_tab_content extends WPBakeryShortCodesContainer {}
}
}


/*******************************/
/* Team Slider Container
/******************************/
if(!function_exists('softing_team_container_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_team_container_integrateWithVC' );
function softing_team_container_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Team Slider Container', 'softing' ),
	'base' 	   => 'softing_team_container',
	"as_parent" 				=> array('only' => 'softing_team_item'),
    "content_element" 			=> true,
    "show_settings_on_create"   => true,
	"js_view" 	=> 'VcColumnView',
	'icon'      => 'icon_slider',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(

        //bg image
        array(
            'type'			=> 'css_editor',
            'heading'		=> esc_html__('Background CSS', 'softing'),
            'param_name'	=> 'css',
            'group'			=> esc_html__('Background', 'softing' )
        ),
        // arrays end
        //slider settings
        array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Loops', 'softing' ),
		'param_name'	=> 'loop',
		'description'	=> esc_html__('let the loop begin ?', 'softing' ),
        'group'			=> esc_html__('Slider Settings', 'softing' ),
        'edit_field_class' => 'vc_col-sm-4',
    		'value'			=> array(
    			esc_html__('Select a option', 'softing' ) => '',
    			esc_html__('Yes', 'softing' ) => 'yes',
    			esc_html__('No', 'softing' ) => 'no',
    		)
		),
        array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Dots', 'softing' ),
		'param_name'	=> 'dots',
		'description'	=> esc_html__('Shall we show the dots ? ?', 'softing' ),
        'group'			=> esc_html__('Slider Settings', 'softing' ),
        'edit_field_class' => 'vc_col-sm-4',
    		'value'			=> array(
    			esc_html__('Select a option', 'softing' ) => '',
    			esc_html__('Yes', 'softing' ) => 'yes',
    			esc_html__('No', 'softing' ) => 'no',
    		)
		),
        array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('AutoPlay', 'softing' ),
		'param_name'	=> 'autoplay',
		'description'	=> esc_html__('let the autoplay begin ?', 'softing' ),
        'group'			=> esc_html__('Slider Settings', 'softing' ),
        'edit_field_class' => 'vc_col-sm-4',
    		'value'			=> array(
    			esc_html__('Select a option', 'softing' ) => '',
    			esc_html__('Yes', 'softing' ) => 'yes',
    			esc_html__('No', 'softing' ) => 'no',
    		)
		),
        array(
        'type'          => 'textfield',
        'heading'       => esc_html__('İtems 600px', 'softing' ),
        'param_name'    => 'items1',
        'description'	=> esc_html__('(Responsive 600 px)number of items you want to see on the screen', 'softing'),
        'edit_field_class' => 'vc_col-sm-4',
        'group'			=> esc_html__('Slider Settings', 'softing' )
        ),
        array(
        'type'          => 'textfield',
        'heading'       => esc_html__('items 1000px', 'softing' ),
        'param_name'    => 'items2',
        'description'	=> esc_html__('(Responsive 1000 px)number of items you want to see on the screen', 'softing'),
        'edit_field_class' => 'vc_col-sm-4',
        'group'			=> esc_html__('Slider Settings', 'softing' )
        ),
        //end slider settings

  	)));
}
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_softing_team_container extends WPBakeryShortCodesContainer {}
}
}

/*******************************/
/* Team Box
/******************************/
if(!function_exists('softing_team_item_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_team_item_integrateWithVC' );
function softing_team_item_integrateWithVC() {
vc_map( array(
	'name' 	 	=> esc_html__( 'Team Box', 'softing' ),
	'base' 	 	=> 'softing_team_item',
	'icon'      => 'icon_team',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
    'params'   => array(
		array(
		'type'			=> 'attach_image',
		'heading'		=> esc_html__('Image', 'softing'),
		'param_name'	=> 'img',
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Image width', 'softing'),
		'description'	=> esc_html__('Use simple number.e.g:300', 'softing'),
		'param_name'	=> 'imgw',
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Image height', 'softing'),
		'description'	=> esc_html__('Use simple number.e.g:300', 'softing'),
		'param_name'	=> 'imgh',
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Name', 'softing'),
		'param_name'	=> 'name',
		'edit_field_class' => 'vc_col-sm-6',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Position/Job', 'softing'),
		'param_name'	=> 'job',
		'edit_field_class' => 'vc_col-sm-6',
		),
		//loop
		array(
		'type'			=> 'param_group',
		'heading'		=> esc_html__('Social icons', 'softing' ),
		'group'			=> esc_html__('Social', 'softing' ),
		'param_name'	=> 'socials',
		'params'		=> array(
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Social icon name', 'softing'),
			'param_name'	=> 'icon',
			'description'   => esc_html__('e.g:fab fa-facebook-f.Visit more details:https://fontawesome.com/icons?d=gallery&s=brands', 'softing' ),
			'edit_field_class' => 'vc_col-sm-6 pt15',
			),
			array(
			'type'        	=> 'textfield',
			'heading'     	=> esc_html__('Icon shortname name', 'softing' ),
			'param_name'  	=> 'iconname',
			'description'   => esc_html__('e.g:facebook', 'softing' ),
			'edit_field_class' => 'vc_col-sm-6',
			),
			array(
			'type'          => 'vc_link',
			'heading'       => esc_html__('Social link', 'softing' ),
			'param_name'    => 'link',
			'description'   => esc_html__('Add team item socials link.', 'softing' ),
			),
		), // params
		), // array
		//icon
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon color', 'softing'),
		'param_name'	=> 'iclr',
		'description'	=> esc_html__('Change icon color.', 'softing'),
		'group'			=> esc_html__('Social', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover icon color', 'softing'),
		'param_name'	=> 'ihvrclr',
		'description'	=> esc_html__('Change icon background.', 'softing'),
		'group'			=> esc_html__('Social', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon size', 'softing'),
		'param_name'	=> 'isz',
		'description'	=> esc_html__('Change icon font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Social', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon line-height', 'softing'),
		'param_name'	=> 'ilh',
		'description'	=> esc_html__('Change icon line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Social', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		//Name
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Name color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change name text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Name font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Change name font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Name line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Change name line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//job
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Job color', 'softing'),
		'param_name'	=> 'jclr',
		'description'	=> esc_html__('Change job text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Job font-size', 'softing'),
		'param_name'	=> 'jsz',
		'description'	=> esc_html__('Change job font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Job line-height', 'softing'),
		'param_name'	=> 'jlh',
		'description'	=> esc_html__('Change job line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Box Background', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		),
		// arrays end
  	)));
}
}

/*******************************/
/* Pricing Box
/******************************/
if(!function_exists('softing_pricing_item_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_pricing_item_integrateWithVC' );
function softing_pricing_item_integrateWithVC() {
vc_map( array(
	'name' 	 	=> esc_html__( 'Pricing Box', 'softing' ),
	'base' 	 	=> 'softing_pricing_item',
	'icon'      => 'icon_pricing',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
    'params'   => array(
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title', 'softing'),
		'param_name'	=> 'title',
		'edit_field_class' => 'vc_col-sm-8 pt15',
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Featured pack?', 'softing' ),
		'param_name'    => 'active',
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Currency', 'softing'),
		'param_name'	=> 'currency',
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Price', 'softing'),
		'param_name'	=> 'price',
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Period', 'softing'),
		'param_name'	=> 'period',
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Pack header background color', 'softing'),
		'param_name'	=> 'prbg',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> '1'
		),
		),
		//loop features
		array(
		'type'			=> 'param_group',
		'heading'		=> esc_html__('Pack features', 'softing' ),
		'param_name'	=> 'features',
		'group'			=> esc_html__('Pack Features', 'softing' ),
		'params'		=> array(
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Features list item', 'softing'),
			'param_name'	=> 'list',
			'description'	=> esc_html__('Add feature for pack this pack.', 'softing'),
			),
			array(
			'type'          => 'checkbox',
			'heading'       => esc_html__('Check?', 'softing' ),
			'param_name'    => 'check',
			'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
			),
		)
		), // array
		//features list
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Features color', 'softing'),
		'param_name'	=> 'fclr',
		'description'	=> esc_html__('Change features text color.', 'softing'),
		'group'			=> esc_html__('Pack Features', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Features font-size', 'softing'),
		'param_name'	=> 'fsz',
		'description'	=> esc_html__('Change features font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Pack Features', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Features line-height', 'softing'),
		'param_name'	=> 'flh',
		'description'	=> esc_html__('Change features line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Pack Features', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//button
		array(
		'type'          => 'vc_link',
		'heading'       => esc_html__('Button', 'softing' ),
		'param_name'    => 'link',
		'description'   => esc_html__('Add button title and link.', 'softing' ),
		'group'			=> esc_html__('Button', 'softing' ),
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Button title color', 'softing'),
		'param_name'	=> 'bclr',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover title color', 'softing'),
		'param_name'	=> 'bhvr',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Background color', 'softing'),
		'param_name'	=> 'bbg',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover background', 'softing'),
		'param_name'	=> 'bhvrbg',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Border color', 'softing'),
		'param_name'	=> 'bbrd',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover Border', 'softing'),
		'param_name'	=> 'bhvrbrd',
		'group'			=> esc_html__('Button', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		//title
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Title color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change pack title color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Change pack title font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Change pack title line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//price
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Price color', 'softing'),
		'param_name'	=> 'prclr',
		'description'	=> esc_html__('Change price text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Price font-size', 'softing'),
		'param_name'	=> 'prsz',
		'description'	=> esc_html__('Change price font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Price line-height', 'softing'),
		'param_name'	=> 'prlh',
		'description'	=> esc_html__('Change price line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//Period
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Period color', 'softing'),
		'param_name'	=> 'perclr',
		'description'	=> esc_html__('Change period text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Period font-size', 'softing'),
		'param_name'	=> 'persz',
		'description'	=> esc_html__('Change period font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Period line-height', 'softing'),
		'param_name'	=> 'perlh',
		'description'	=> esc_html__('Change period line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Pack Background', 'softing' ),
		),
		// arrays end
  	)));
}
}


/*******************************/
/* Testimonials Slider
/******************************/
if(!function_exists('softing_testimonial_slider_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_testimonial_slider_integrateWithVC' );
function softing_testimonial_slider_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Testimonials Slider', 'softing' ),
	'base' 	   => 'softing_testimonial_slider',
	'icon'      => 'icon_testimonial',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(

		//loop
		array(
		'type'			=> 'param_group',
		'heading'		=> esc_html__('Slider Items', 'softing' ),
		'param_name'	=> 'loop',
		'params'		=> array(
			array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__('Image', 'softing'),
			'param_name'	=> 'img',
			),
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Name', 'softing'),
			'param_name'	=> 'name',
			'edit_field_class' => 'vc_col-sm-6',
			),
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Position/Job', 'softing'),
			'param_name'	=> 'job',
			'edit_field_class' => 'vc_col-sm-6',
			),
			array(
			'type'			=> 'textarea',
			'heading'		=> esc_html__('Quote text', 'softing'),
			'param_name'	=> 'quote',
			'description'	=> esc_html__('Add review here.', 'softing'),
			),
		), // params
		), // array
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Testimonial image width', 'softing'),
		'description'	=> esc_html__('Use simple number without ( px or unit ).e.g: 80', 'softing'),
		'param_name'	=> 'imgw',
		'edit_field_class' => 'vc_col-sm-6',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Testimonial image height', 'softing'),
		'description'	=> esc_html__('Use simple number without ( px or unit ).e.g: 80', 'softing'),
		'param_name'	=> 'imgh',
		'edit_field_class' => 'vc_col-sm-6',
		),
		//Name
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Name color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change name text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Name font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Change name font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Name line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Change name line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//job
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Job color', 'softing'),
		'param_name'	=> 'jclr',
		'description'	=> esc_html__('Change job text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Job font-size', 'softing'),
		'param_name'	=> 'jsz',
		'description'	=> esc_html__('Change job font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Job line-height', 'softing'),
		'param_name'	=> 'jlh',
		'description'	=> esc_html__('Change job line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//quote
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Review color', 'softing'),
		'param_name'	=> 'pclr',
		'description'	=> esc_html__('Change review text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Review font-size', 'softing'),
		'param_name'	=> 'psz',
		'description'	=> esc_html__('Change review font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Review line-height', 'softing'),
		'param_name'	=> 'plh',
		'description'	=> esc_html__('Change review line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//quote icon
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon color', 'softing'),
		'param_name'	=> 'iclr',
		'description'	=> esc_html__('Change icon text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon background color', 'softing'),
		'param_name'	=> 'ibg',
		'description'	=> esc_html__('Change icon background color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon font-size', 'softing'),
		'param_name'	=> 'isz',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon line-height', 'softing'),
		'param_name'	=> 'ilh',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		//bg css
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		),
      // arrays end
  	)));
}
}

/*******************************/
/* Clients Slider
/******************************/
if(!function_exists('softing_clients_slider_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_clients_slider_integrateWithVC' );
function softing_clients_slider_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Clients Slider', 'softing' ),
	'base' 	   => 'softing_clients_slider',
	'icon'      => 'icon_slider',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(

		//loop
		array(
		'type'			=> 'param_group',
		'heading'		=> esc_html__('Slider Items', 'softing' ),
		'param_name'	=> 'loop',
		'params'		=> array(
			array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__('Image', 'softing'),
			'param_name'	=> 'img',
			),
			array(
			'type'			=> 'vc_link',
			'heading'		=> esc_html__('Client link', 'softing'),
			'param_name'	=> 'link',
			),
		), // params
		), // array
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Client image width', 'softing'),
		'description'	=> esc_html__('Use simple number without ( px or unit ).e.g: 200', 'softing'),
		'param_name'	=> 'imgw',
		'edit_field_class' => 'vc_col-sm-6',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Client image height', 'softing'),
		'description'	=> esc_html__('Use simple number without ( px or unit ).e.g: 100', 'softing'),
		'param_name'	=> 'imgh',
		'edit_field_class' => 'vc_col-sm-6',
		),
		//bg css
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		),
      // arrays end
      array(
    'type'			=> 'dropdown',
    'heading'		=> esc_html__('Loops', 'softing' ),
    'param_name'	=> 'loops',
    'description'	=> esc_html__('let the loop begin ?', 'softing' ),
      'group'			=> esc_html__('Slider Settings', 'softing' ),
      'edit_field_class' => 'vc_col-sm-4',
        'value'			=> array(
            esc_html__('Select a option', 'softing' ) => '',
            esc_html__('Yes', 'softing' ) => 'yes',
            esc_html__('No', 'softing' ) => 'no',
        )
    ),
      array(
    'type'			=> 'dropdown',
    'heading'		=> esc_html__('Dots', 'softing' ),
    'param_name'	=> 'dotss',
    'description'	=> esc_html__('Shall we show the dots ?', 'softing' ),
      'group'			=> esc_html__('Slider Settings', 'softing' ),
      'edit_field_class' => 'vc_col-sm-4',
        'value'			=> array(
            esc_html__('Select a option', 'softing' ) => '',
            esc_html__('Yes', 'softing' ) => 'yes',
            esc_html__('No', 'softing' ) => 'no',
        )
    ),
      array(
    'type'			=> 'dropdown',
    'heading'		=> esc_html__('AutoPlay', 'softing' ),
    'param_name'	=> 'autoplays',
    'description'	=> esc_html__('let the autoplay begin ?', 'softing' ),
      'group'			=> esc_html__('Slider Settings', 'softing' ),
      'edit_field_class' => 'vc_col-sm-4',
        'value'			=> array(
            esc_html__('Select a option', 'softing' ) => '',
            esc_html__('Yes', 'softing' ) => 'yes',
            esc_html__('No', 'softing' ) => 'no',
        )
    ),
    array(
    'type'          => 'textfield',
    'heading'       => esc_html__('İtems 600px', 'softing' ),
    'param_name'    => 'items1',
    'description'	=> esc_html__('(Responsive 600 px)number of items you want to see on the screen', 'softing'),
    'edit_field_class' => 'vc_col-sm-4',
    'group'			=> esc_html__('Slider Settings', 'softing' )
    ),
    array(
    'type'          => 'textfield',
    'heading'       => esc_html__('items 1000px', 'softing' ),
    'param_name'    => 'items2',
    'description'	=> esc_html__('(Responsive 1000 px)number of items you want to see on the screen', 'softing'),
    'edit_field_class' => 'vc_col-sm-4',
    'group'			=> esc_html__('Slider Settings', 'softing' )
    ),
  	)));
}
}

/*******************************/
/* Overwiew Slider
/******************************/
if(!function_exists('softing_overwiew_slider_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_overwiew_slider_integrateWithVC' );
function softing_overwiew_slider_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Overwiew Slider', 'softing' ),
	'base' 	   => 'softing_overwiew_slider',
	'icon'      => 'icon_slider',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Style', 'softing' ),
		'param_name'	=> 'style',
		'description'	=> esc_html__('You can select item style.', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option', 'softing' ) => '',
			esc_html__('Style 1', 'softing' ) => '1',
			esc_html__('Style 2', 'softing' ) => '2',
		)
		),
		array(
		'type'			=> 'attach_images',
		'heading'		=> esc_html__('Images', 'softing'),
		'param_name'	=> 'images',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> '1'
		)
		),
		//loop
		array(
		'type'			=> 'param_group',
		'heading'		=> esc_html__('Slider Items', 'softing' ),
		'param_name'	=> 'loop',
		'params'		=> array(
			array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__('Image', 'softing'),
			'param_name'	=> 'img',
			),
			array(
			'type'			=> 'textarea',
			'heading'		=> esc_html__('Title', 'softing'),
			'param_name'	=> 'title',
			),
			array(
			'type'			=> 'textarea',
			'heading'		=> esc_html__('Description', 'softing'),
			'param_name'	=> 'desc',
			),
			array(
			'type'			=> 'vc_link',
			'heading'		=> esc_html__('Link', 'softing'),
			'param_name'	=> 'link',
			),
		),
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> '2'
		)
		), // array
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Image width', 'softing'),
		'description'	=> esc_html__('Use simple number without ( px or unit ).e.g: 1200', 'softing'),
		'param_name'	=> 'imgw',
		'edit_field_class' => 'vc_col-sm-6',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Image height', 'softing'),
		'description'	=> esc_html__('Use simple number without ( px or unit ).e.g: 800', 'softing'),
		'param_name'	=> 'imgh',
		'edit_field_class' => 'vc_col-sm-6',
		),
		//bg css
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		),
      // arrays end
      array(
    'type'			=> 'dropdown',
    'heading'		=> esc_html__('Loops', 'softing' ),
    'param_name'	=> 'loops',
    'description'	=> esc_html__('let the loop begin ?', 'softing' ),
      'group'			=> esc_html__('Slider Settings', 'softing' ),
      'edit_field_class' => 'vc_col-sm-4',
        'value'			=> array(
            esc_html__('Select a option', 'softing' ) => '',
            esc_html__('Yes', 'softing' ) => 'yes',
            esc_html__('No', 'softing' ) => 'no',
        )
    ),
      array(
    'type'			=> 'dropdown',
    'heading'		=> esc_html__('Dots', 'softing' ),
    'param_name'	=> 'dotss',
    'description'	=> esc_html__('Shall we show the dots ?', 'softing' ),
      'group'			=> esc_html__('Slider Settings', 'softing' ),
      'edit_field_class' => 'vc_col-sm-4',
        'value'			=> array(
            esc_html__('Select a option', 'softing' ) => '',
            esc_html__('Yes', 'softing' ) => 'yes',
            esc_html__('No', 'softing' ) => 'no',
        )
    ),
      array(
    'type'			=> 'dropdown',
    'heading'		=> esc_html__('AutoPlay', 'softing' ),
    'param_name'	=> 'autoplays',
    'description'	=> esc_html__('let the autoplay begin ?', 'softing' ),
      'group'			=> esc_html__('Slider Settings', 'softing' ),
      'edit_field_class' => 'vc_col-sm-4',
        'value'			=> array(
            esc_html__('Select a option', 'softing' ) => '',
            esc_html__('Yes', 'softing' ) => 'yes',
            esc_html__('No', 'softing' ) => 'no',
        )
    ),
      array(
      'type'          => 'textfield',
      'heading'       => esc_html__('İtems', 'softing' ),
      'param_name'    => 'items',
      'description'	=> esc_html__('number of items you want to see on the screen', 'softing'),
      'edit_field_class' => 'vc_col-sm-4',
      'group'			=> esc_html__('Slider Settings', 'softing' )
      ),
  	)));
}
}

/*******************************/
/* Blog Post Loop
/******************************/
if(!function_exists('softing_blog_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_blog_integrateWithVC' );
function softing_blog_integrateWithVC() {
vc_map( array(
	'name'		=> esc_html__('Blog Post Loop', 'softing'),
	'base'		=> 'softing_blog',
	'icon'		=> 'icon_blogging',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'	=> array(
		array(
		"type" 			=> "loop",
		"heading" 		=> esc_html__("Post Query", 'softing' ),
		"param_name" 	=> "build_query",
		'settings' 		=> array(
		'size' 			=> array('hidden' => false, 'value' =>  ''),
		'order_by' 		=> array('value' => 'date'),
		'post_type' 	=> array('value' => 'post', 'hidden' => false)
		),
		"description" 	=> esc_html__("Create WordPress loop, to populate products from your site.", 'softing' )
		),
		// Post style
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Grid Column?', 'softing' ),
		'param_name'	=> 'gridcol',
		'description'	=> esc_html__('You can select show or hide title', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6',
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('Full', 'softing' )		=> '12',
			esc_html__('2 Column', 'softing' )	=> '6',
			esc_html__('3 Column', 'softing' )	=> '4',
			esc_html__('4 Column', 'softing' )	=> '3',
		)
		),
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Content text and image alignment?', 'softing' ),
		'param_name'	=> 'textalign',
		'edit_field_class' => 'vc_col-sm-6',
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('Left', 'softing' )	=> 'text-left',
			esc_html__('Center', 'softing' )=> 'text-center',
			esc_html__('Right', 'softing' )	=> 'text-right',
		),
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Pagination?', 'softing' ),
		'param_name'    => 'pag',
		'value' 		=> array( esc_html__( 'Show', 'softing' ) => 'yes' ),
		'description'   => esc_html__('If checked, the page pagination will be enabled.', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6',
		),
		// Post thumb
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Hide post image', 'softing' ),
		'param_name'    => 'hidethumb',
		'value' 		=> array( esc_html__( 'Hide', 'softing' ) => 'hide' ),
		'description'   => esc_html__('If checked, the post thumbnail image will be disabled.', 'softing' ),
		'group'			=> esc_html__('Post Image', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Post image width', 'softing'),
		'param_name'	=> 'imgw',
		'description'	=> esc_html__('Change post thumbnail image width or leave it blank.Note: use simple number without px or unit.', 'softing'),
		'group'			=> esc_html__('Post Image', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'hidethumb',
			'is_empty'  => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Post image height', 'softing'),
		'param_name'	=> 'imgh',
		'description'	=> esc_html__('Change post thumbnail image height or leave it blank.Note: use simple number without px or unit.', 'softing'),
		'group'			=> esc_html__('Post Image', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'hidethumb',
			'is_empty'  => true
		)
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Full image size', 'softing' ),
		'param_name'    => 'fullthumb',
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
		'description'   => esc_html__('If checked, the post thumbnail image will be not cropped.', 'softing' ),
		'group'			=> esc_html__('Post Image', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6',
		),
		// Post title
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Hide post title', 'softing' ),
		'param_name'    => 'hidetitle',
		'value' 		=> array( esc_html__( 'Hide', 'softing' ) => 'hide' ),
		'description'   => esc_html__('If checked, the post title will be disabled.', 'softing' ),
		'group'			=> esc_html__('Post Title', 'softing' ),
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Title color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change post title color.', 'softing'),
		'group'			=> esc_html__('Post Title', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'hidetitle',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover title', 'softing'),
		'param_name'	=> 'thvrclr',
		'description'	=> esc_html__('Change post title color.', 'softing'),
		'group'			=> esc_html__('Post Title', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'hidetitle',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Change post title font-size.use number in( px or unit )', 'softing'),
		'group'			=> esc_html__('Post Title', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'hidetitle',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Change post title line-height.use number in( px or unit )', 'softing'),
		'group'			=> esc_html__('Post Title', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		'dependency' 	=> array(
			'element' 	=> 'hidetitle',
			'is_empty' => true
		)
		),
		//taxonomies
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Hide author', 'softing' ),
		'param_name'    => 'hideauthor',
		'value' 		=> array( esc_html__( 'Hide', 'softing' ) => 'hide' ),
		'description'   => esc_html__('If checked, the post author will be disabled.', 'softing' ),
		'group'			=> esc_html__('Post Meta', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Hide date', 'softing' ),
		'param_name'    => 'hidedate',
		'value' 		=> array( esc_html__( 'Hide', 'softing' ) => 'hide' ),
		'description'   => esc_html__('If checked, the post date will be disabled.', 'softing' ),
		'group'			=> esc_html__('Post Meta', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Hide comment', 'softing' ),
		'param_name'    => 'hidecom',
		'value' 		=> array( esc_html__( 'Hide', 'softing' ) => 'hide' ),
		'std' 			=> true,
		'description'   => esc_html__('If checked, the post comment number will be disabled.', 'softing' ),
		'group'			=> esc_html__('Post Meta', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Post meta color', 'softing'),
		'param_name'	=> 'cclr',
		'description'	=> esc_html__('Change post category color.', 'softing'),
		'group'			=> esc_html__('Post Meta', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Post meta font-size', 'softing'),
		'param_name'	=> 'csz',
		'description'	=> esc_html__('Change post meta font-size.use number in( px or unit )', 'softing'),
		'group'			=> esc_html__('Post Meta', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Post meta line-height', 'softing'),
		'param_name'	=> 'clh',
		'description'	=> esc_html__('Change post meta line-height.use number in( px or unit )', 'softing'),
		'group'			=> esc_html__('Post Meta', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//post content
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Hide content text', 'softing' ),
		'param_name'    => 'hidetext',
		'value' 		=> array( esc_html__( 'Hide', 'softing' ) => 'hide' ),
		'description'   => esc_html__('If checked, the post content text will be disabled.', 'softing' ),
		'group'			=> esc_html__('Post Text', 'softing' ),
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Excerpt limit', 'softing'),
		'param_name'	=> 'excerptsz',
		'description'	=> esc_html__('You can control with limit the content text.Use simple number.e.g:25', 'softing'),
		'group'			=> esc_html__('Post Text', 'softing' ),
		'dependency' 	=> array(
			'element' 	=> 'hidetext',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Excerpt color', 'softing'),
		'param_name'	=> 'pclr',
		'description'	=> esc_html__('Change excerpt color.', 'softing'),
		'group'			=> esc_html__('Post Text', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'hidetext',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Excerpt font-size', 'softing'),
		'param_name'	=> 'psz',
		'description'	=> esc_html__('Change excerpt font-size.use number in( px or unit )', 'softing'),
		'group'			=> esc_html__('Post Text', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'hidetext',
			'is_empty' => true
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Excerpt text line-height', 'softing'),
		'param_name'	=> 'plh',
		'description'	=> esc_html__('Change excerpt line-height.use number in( px or unit )', 'softing'),
		'group'			=> esc_html__('Post Text', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'hidetext',
			'is_empty' => true
		)
		),
		//Background CSS
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		)
  )));
}
}


/*******************************/
/* Features item
/******************************/
if(!function_exists('softing_features_item_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_features_item_integrateWithVC' );
function softing_features_item_integrateWithVC() {
vc_map( array(
	'name' 	   => esc_html__( 'Features Item', 'softing' ),
	'base' 	   => 'softing_features_item',
	'icon'      => 'icon_service',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
	'params'   => array(
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Style', 'softing' ),
		'param_name'	=> 'style',
		'description'	=> esc_html__('You can select item style.', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('Style 1', 'softing' ) => '1',
			esc_html__('Style 2', 'softing' ) => '2',
		)
		),
		//title
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Title', 'softing'),
		'param_name'	=> 'title',
		'description'	=> esc_html__('Add title.', 'softing'),
		),
		//desc
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Description', 'softing'),
		'param_name'	=> 'desc',
		'description'	=> esc_html__('Add description here.', 'softing'),
		),
		//icon
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Select icon from library', 'softing' ),
		'param_name'    => 'iconlist',
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'          => 'checkbox',
		'heading'       => esc_html__('Use image icon', 'softing' ),
		'param_name'    => 'useimgicon',
		'value' 		=> array( esc_html__( 'Yes', 'softing' ) => 'yes' ),
		'edit_field_class' => 'vc_col-sm-6',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Custom icon name', 'softing'),
		'param_name'	=> 'icon',
		'edit_field_class' => 'vc_col-sm-6',
		'dependency' 	=> array(
			'element' 	=> 'iconlist',
			'is_empty'  => true
		),
		),
		array(
		'type'			=> 'attach_image',
		'heading'		=> esc_html__('Image icon', 'softing'),
		'param_name'	=> 'imgicon',
		'edit_field_class' => 'vc_col-sm-6',
		'dependency' 	=> array(
			'element' 	=> 'useimgicon',
			'not_empty' => true
		),
		),
		array(
		'type'        	=> 'iconpicker',
		'heading'     	=> esc_html__('Icon', 'softing' ),
		'description' 	=> esc_html__('Select icon from library.', 'softing' ),
		'param_name'  	=> 'icon2',
		'settings' 		=> array(
			'emptyIcon' 	=> true,
			'type' => 'fontawesomeall',
			'iconsPerPage' 	=> 200,
		),
		'dependency' 	=> array(
			'element' 	=> 'iconlist',
			'not_empty' => true
		),
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Box background color', 'softing'),
		'param_name'	=> 'primarybg',
		),
		//title
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Title color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change title color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4 pt15'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		//description
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Description color', 'softing'),
		'param_name'	=> 'pclr',
		'description'	=> esc_html__('Change description color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Description font-size', 'softing'),
		'param_name'	=> 'psz',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Description line-height', 'softing'),
		'param_name'	=> 'plh',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		//icon
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon color', 'softing'),
		'param_name'	=> 'iclr',
		'description'	=> esc_html__('Change description color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon background', 'softing'),
		'param_name'	=> 'ibg',
		'description'	=> esc_html__('Change icon background color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon font-size', 'softing'),
		'param_name'	=> 'isz',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon line-height', 'softing'),
		'param_name'	=> 'ilh',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-3'
		),
		//bg image
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Background CSS', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		),
      // arrays end
  	)));
}
}

/*******************************/
/* List Item
/******************************/
if(!function_exists('softing_list_item_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_list_item_integrateWithVC' );
function softing_list_item_integrateWithVC() {
vc_map( array(
	'name' 	 	=> esc_html__( 'List Item', 'softing' ),
	'base' 	 	=> 'softing_list_item',
	'icon'      => 'icon_list',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
    'params'   => array(
		array(
		'type'			=> 'dropdown',
		'heading'		=> esc_html__('Style', 'softing' ),
		'param_name'	=> 'style',
		'description'	=> esc_html__('You can select item style.', 'softing' ),
		'value'			=> array(
			esc_html__('Select a option', 'softing' )	=> '',
			esc_html__('Style 1', 'softing' ) => '1',
			esc_html__('Style 2', 'softing' ) => '2',
			esc_html__('Style 3', 'softing' ) => '3',
		)
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon name', 'softing'),
		'param_name'	=> 'icon',
		'description'   => esc_html__('e.g:fas fa-check.Visit more details:https://fontawesome.com/icons?d=gallery&s=brands', 'softing' ),
		),
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Title', 'softing'),
		'param_name'	=> 'title',
		),
		array(
		'type'			=> 'textarea',
		'heading'		=> esc_html__('Description', 'softing'),
		'param_name'	=> 'desc',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> '2',
		),
		),
		//icon
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon color', 'softing'),
		'param_name'	=> 'iclr',
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon background', 'softing'),
		'param_name'	=> 'ibg',
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon size', 'softing'),
		'param_name'	=> 'isz',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon line-height', 'softing'),
		'param_name'	=> 'ilh',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-6'
		),
		//Name
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Title color', 'softing'),
		'param_name'	=> 'tclr',
		'description'	=> esc_html__('Change title text color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title font-size', 'softing'),
		'param_name'	=> 'tsz',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Title line-height', 'softing'),
		'param_name'	=> 'tlh',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		),
		//description
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Description color', 'softing'),
		'param_name'	=> 'jclr',
		'description'	=> esc_html__('Change description color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> '2',
		),
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Description font-size', 'softing'),
		'param_name'	=> 'jsz',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> '2',
		),
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Description line-height', 'softing'),
		'param_name'	=> 'jlh',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4',
		'dependency' 	=> array(
			'element' 	=> 'style',
			'value'  	=> '2',
		),
		),
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Box Background', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		),
		// arrays end
  	)));
}
}

/*******************************/
/* Social Icons
/******************************/
if(!function_exists('softing_social_icons_integrateWithVC')) {

add_action( 'vc_before_init', 'softing_social_icons_integrateWithVC' );
function softing_social_icons_integrateWithVC() {
vc_map( array(
	'name' 	 	=> esc_html__( 'Social Icons', 'softing' ),
	'base' 	 	=> 'softing_social_icons',
	'icon'      => 'icon_social',
	'category'	=> 'SOFTING',
	'admin_enqueue_css' => array( get_template_directory_uri() . '/vc_templates/vc-icon/vc-icon.css' ),
    'params'   => array(

		//loop features
		array(
		'type'			=> 'param_group',
		'heading'		=> esc_html__('Social icons', 'softing' ),
		'param_name'	=> 'socials',
		'params'		=> array(
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Icon name', 'softing'),
			'param_name'	=> 'icon',
			'edit_field_class' => 'vc_col-sm-6 pt15',
			),
			array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__('Icon shortname', 'softing'),
			'param_name'	=> 'iconname',
			'edit_field_class' => 'vc_col-sm-6',
			),
			array(
			'type'          => 'vc_link',
			'heading'       => esc_html__('Social link', 'softing' ),
			'param_name'    => 'link',
			'description'   => esc_html__('Add socials link.', 'softing' )
			)
		)
		),
		//icon style
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon color', 'softing'),
		'param_name'	=> 'iclr',
		'description'	=> esc_html__('Change icon color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon font-size', 'softing'),
		'param_name'	=> 'isz',
		'description'	=> esc_html__('Change icon font-size.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon line-height', 'softing'),
		'param_name'	=> 'ilh',
		'description'	=> esc_html__('Change icon line-height.Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon height', 'softing'),
		'param_name'	=> 'iw',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__('Icon height', 'softing'),
		'param_name'	=> 'ih',
		'description'	=> esc_html__('Use number in ( px or unit )', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Icon background', 'softing'),
		'param_name'	=> 'ibg',
		'description'	=> esc_html__('Change icon background.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover background', 'softing'),
		'param_name'	=> 'ihvrbg',
		'description'	=> esc_html__('Change icon hover background.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		array(
		'type'			=> 'colorpicker',
		'heading'		=> esc_html__('Hover icon color', 'softing'),
		'param_name'	=> 'ihvr',
		'description'	=> esc_html__('Change icon hover color.', 'softing'),
		'group'			=> esc_html__('Custom Style', 'softing' ),
		'edit_field_class' => 'vc_col-sm-4'
		),
		//bg css
		array(
		'type'			=> 'css_editor',
		'heading'		=> esc_html__('Box Background', 'softing'),
		'param_name'	=> 'css',
		'group'			=> esc_html__('Background', 'softing' ),
		),
  	)));
}
}
