<?php

// plugin version number for body classes
function softing_plugin_version($classes) {
  $data = get_plugin_data( __FILE__ );
  $version = $data['Version'];
  $version =  'nt-shortcode-' . $version;
  $classes[] =  $version;
  return $classes;
}
add_filter('body_class','softing_plugin_version');


if ( ! function_exists( 'softing_style' ) ) {
    function softing_style( $elemcss = array() ) {
		$css = array();
		foreach ( $elemcss as $key => $val ) {
			if(isset($val) && $val != '' ){
			array_push($css, $key.':'.$val.';' );
			}
		}

		return implode( ' ', array_filter( $css ) );

	}
}


// image function
if ( ! function_exists( 'softing_img' ) ) {
    function softing_img( $imgsrc='', $imgclass='', $imgwidth='', $imgheight='' ) {

		if ( ( isset( $imgsrc ) ) && ( $imgsrc != '' ) ) {

			// Gets url of the image
			$image = wp_get_attachment_url( $imgsrc,'full' );
			// Gets the Image alt
			$image_alt = get_post_meta( $imgsrc, '_wp_attachment_image_alt', true );
			// Gets the image name with exstention
			$image_filename = basename ( get_attached_file( $imgsrc ) );
			// Gets the image name without exstention
			$image_title = get_the_title( $imgsrc );

			if (  $image_alt != '' ) {
				$imagealt = $image_alt;
			}else{
				$imagealt = $image_filename;
			}

			// Gets url of the image
			$img_src     = ( isset( $imgsrc    	) && $imgsrc    != '' 	) 	? 	' src="'.esc_url( $image ).'"' 			: '';
			$img_class   = ( isset( $imgclass  	) && $imgclass  != '' 	) 	? 	' class="'.esc_attr( $imgclass ).'"' 	: '';
			$img_width   = ( isset( $imgwidth  	) && $imgwidth  != '' 	) 	? 	' width="'.esc_attr( $imgwidth ).'"' 	: '';
			$img_height  = ( isset( $imgheight 	) && $imgheight != '' 	) 	? 	' height="'.esc_attr( $imgheight ).'"' 	: '';
			$img_alt     = ( $imagealt != '' ) ? ' alt="'.esc_attr( $imagealt ).'"' : '';

			$c_img_w = (is_numeric($imgwidth)) ? (int) $imgwidth : '';
			$c_img_h = (is_numeric($imgheight)) ? (int) $imgheight : '';
			if (  $image != '' && $c_img_w != '' && $c_img_h != '' ) {
				$cropimg = ntframework_aq_resize( $image, $c_img_w, $c_img_h , true, true, true );
                if ( $cropimg == false ) {
                    $imageo = wp_get_attachment_image( $imgsrc, [$c_img_w, $c_img_h] );
                } else {
                    $imageo = '<img src="'.$cropimg.'" alt="'.get_the_title().'" />';
                }

			} else {

				$imageo  = '<img'.$img_src . $img_class . $img_width . $img_height . $img_alt .'>';

			}

			return $imageo;
		}
		else{
			return false;
		} // end imgsrc

  } // end softing_img
} // end function_exists

// vc row divider shape
if ( ! function_exists( 'softing_vc_row_divider' ) ){
    function softing_vc_row_divider($atts){

        extract( $atts );

        if($nt_shape_divider == 'yes') {

            $uniq = 'shape_'.uniqid();
            $height = $divider_height ? $divider_height : '300px';
            $x_axis = $divider_rotate_x ? '1' : '0';
            $y_axis = $divider_rotate_y ? '1' : '0';

            $rotate_w = ' data-res-css=".nt-shape-wrapper.'.$uniq.'{display: block;width:100%;height:'.esc_attr( $height).'px;position:absolute;left:0;'.$divider_position.':-1px; -webkit-transform:rotate3d(0, '.$y_axis.', 0, 180deg);transform:rotate3d(0, '.$y_axis.', 0, 180deg);}"';

            $rotate = $x_axis ? ' -webkit-transform:rotate3d('.$x_axis.', 0, 0, 180deg);transform:rotate3d('.$x_axis.', 0, 0, 180deg);' : '';
            $color = $divider_color ? $divider_color : '#fff';

            $position = $divider_position == 'top' ? 'pos-top' : 'pos-bottom';
            $lg_css = $lg_divider_height != '' ? '@media (max-width:1200px){.nt-shape-wrapper.'.$uniq.',.nt-shape.'.$uniq.'{height:'.esc_attr( $lg_divider_height).'px;background-size:100% '.esc_attr( $lg_divider_height).'px;}}' : '';
            $md_css = $md_divider_height != '' ? '@media (max-width:992px){.nt-shape-wrapper.'.$uniq.',.nt-shape.'.$uniq.'{height:'.esc_attr( $md_divider_height).'px;background-size:100% '.esc_attr( $md_divider_height).'px;}}' : '';
            $sm_css = $sm_divider_height != '' ? '@media (max-width:768px){.nt-shape-wrapper.'.$uniq.',.nt-shape.'.$uniq.'{height:'.esc_attr( $sm_divider_height).'px;background-size:100% '.esc_attr( $sm_divider_height).'px;}}' : '';
            $res_css = $lg_css.$md_css.$sm_css;
            $style = 'background-size:100% '.esc_attr( $height).'px;background-repeat:no-repeat;width:100%;height:'.esc_attr( $height).'px;display: block;position:absolute;left:0;'.$rotate;

            if ( $divider_style == 'type-1' ) {

            	$divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="282px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M0 47.44L170 0l626.48 94.89L1110 87.11l170-39.67V140H0V47.44z" fill-opacity=".5"/><path d="M0 90.72l140-28.28 315.52 24.14L796.48 65.8 1140 104.89l140-14.17V140H0V90.72z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-2' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="277px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M0 140l640-70 640 70V0L640 70 0 0v140z" fill-opacity=".5"/><path d="M0 140h1280L640 70 0 140z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-3' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="500px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M0 0v140h1280L0 0z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-4' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="200px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M1280 0l-266 91.52a72.59 72.59 0 0 1-30.76 3.71L0 0v140h1280z" fill-opacity=".5"/><path d="M1280 0l-262.1 116.26a73.29 73.29 0 0 1-39.09 6L0 0v140h1280z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-5' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" viewBox="0 0 1280 86" preserveAspectRatio="xMidYMid slice" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M1280 66.1c-3.8 0-7.6.3-11.4.8-18.3-32.6-59.6-44.2-92.2-25.9-3.5 2-6.9 4.3-10 6.9-22.7-41.7-74.9-57.2-116.6-34.5-14.2 7.7-25.9 19.3-33.8 33.3-.2.3-.3.6-.5.8-12.2-1.4-23.7 5.9-27.7 17.5-11.9-6.1-25.9-6.3-37.9-.6-21.7-30.4-64-37.5-94.4-15.7-12.1 8.6-21 21-25.4 35.2-10.8-9.3-24.3-15-38.5-16.2-8.1-24.6-34.6-38-59.2-29.9-14.3 4.7-25.5 16-30 30.3-4.3-1.9-8.9-3.2-13.6-3.8-13.6-45.5-61.5-71.4-107-57.8a86.38 86.38 0 0 0-43.2 29.4c-8.7-3.6-18.7-1.8-25.4 4.8-23.1-24.8-61.9-26.2-86.7-3.1-7.1 6.6-12.5 14.8-15.9 24-26.7-10.1-56.9-.4-72.8 23.3-2.6-2.7-5.6-5.1-8.9-6.9-.4-.2-.8-.4-1.2-.7-.6-25.9-22-46.4-47.9-45.8-11.5.3-22.5 4.7-30.9 12.5-16.5-33.5-57.1-47.3-90.6-30.8-21.9 11-36.3 32.7-37.6 57.1-7-2.3-14.5-2.8-21.8-1.6C84.8 47 55.7 40.7 34 54.8c-5.6 3.6-10.3 8.4-13.9 14-6.6-1.7-13.3-2.6-20.1-2.6-.1 0 0 19.8 0 19.8h1280V66.1z" fill-opacity=".5"/><path d="M15.6 86H1280V48.5c-3.6 1.1-7.1 2.5-10.4 4.4-6.3 3.6-11.8 8.5-16 14.5-8.1-1.5-16.4-.9-24.2 1.7-3.2-39-37.3-68.1-76.4-64.9-24.8 2-46.8 16.9-57.9 39.3-19.9-18.5-51-17.3-69.4 2.6-8.2 8.8-12.8 20.3-13.1 32.3-.4.2-.9.4-1.3.7-3.5 1.9-6.6 4.4-9.4 7.2-16.6-24.9-48.2-35-76.2-24.4-12.2-33.4-49.1-50.6-82.5-38.4-9.5 3.5-18.1 9.1-25 16.5-7.1-6.9-17.5-8.8-26.6-5-30.4-39.3-87-46.3-126.2-15.8-14.8 11.5-25.6 27.4-31 45.4-4.9.6-9.7 1.9-14.2 3.9-8.2-25.9-35.8-40.2-61.7-32-15 4.8-26.9 16.5-31.8 31.5-14.9 1.3-29 7.2-40.3 17-11.5-37.4-51.2-58.4-88.7-46.8-14.8 4.6-27.7 13.9-36.7 26.5-12.6-6-27.3-5.7-39.7.6-4.1-12.2-16.2-19.8-29-18.4-.2-.3-.3-.6-.5-.9-24.4-43.3-79.4-58.6-122.7-34.2-13.3 7.5-24.4 18.2-32.4 31.2C99.8 18.5 50 28.5 25.4 65.4c-4.3 6.4-7.5 13.3-9.8 20.6z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-6' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="300px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M0 70.35l320-49.24 640 98.49 320-49.25V140H0V70.35z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-7' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="425px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M1280 3.4C1050.59 18 1019.4 84.89 734.42 84.89c-320 0-320-84.3-640-84.3C59.4.59 28.2 1.6 0 3.4V140h1280z" fill-opacity=".3"/><path d="M0 24.31c43.46-5.69 94.56-9.25 158.42-9.25 320 0 320 89.24 640 89.24 256.13 0 307.28-57.16 481.58-80V140H0z" fill-opacity=".5"/><path d="M1280 51.76c-201 12.49-242.43 53.4-513.58 53.4-320 0-320-57-640-57-48.85.01-90.21 1.35-126.42 3.6V140h1280z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-8' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="300px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M1280 140V0H0l1280 140z" fill-opacity=".5"/><path d="M1280 98V0H0l1280 98z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-9' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="700px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M0 140h1280C573.08 140 0 0 0 0z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            } elseif ( $divider_style == 'type-10' ) {

                $divider_html = '<div class="nt-shape-wrapper '.$uniq.'"'.$rotate_w.'><div class="nt-shape '.esc_attr($position).' '.$uniq.'" data-res-css=".nt-shape.'.$uniq.'{background-image:url(data:image/svg+xml;base64,'.base64_encode('<svg width="100%" height="300px" viewBox="0 0 1280 140" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg"><g fill="'.esc_attr( $color).'"><path d="M0 0l64.8 30.95 91.2-2.54 95.46 27.87 120.04.2L443 83.15l90.09-3.12L640 110.12l102.39-29.73 85.55 8.51 88.11-5.75L992 52.22l73.21 4.26L1132 38.79l77-.33L1280 0v140H0V0z" fill-opacity=".5"/><path d="M0 0l64.8 38.69 91.2-3.18 95.46 34.84 120.04.24 71.5 33.35 90.09-3.91L640 137.65l102.39-37.17 85.55 10.65 88.11-7.19L992 65.28l73.21 5.31 66.79-22.1 77-.41L1280 0v140H0V0z"/></g></svg>').');'.$style.'}'.$res_css.'"></div></div>';

            }
            return $divider_html;
        }
    }
}
