<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $equal_height
 * @var $columns_placement
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $parallax_speed_bg
 * @var $parallax_speed_video
 * @var $content - shortcode content
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
*/

$el_class = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $equal_height = $flex_row =
$columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax  =  '';

//extra row atts
$softing_row_prepad = '';

$softing_parallax_speed = $softing_bg_pos = $softing_row_overflow = $softing_parallax_bg_opacity = $softing_mobile_parallax = '';
$softing_lg_bgpos = $softing_md_bgpos = $softing_sm_bgpos = $softing_xs_bgpos = '';

$softing_lg_custom_bgpos = $softing_md_custom_bgpos = $softing_sm_custom_bgpos = $softing_xs_custom_bgpos = '';

$softing_bgsize = $softing_custom_bgsize = $softing_custom_bgpos = $softing_bgrepeat = $softing_bg_attachment = '';

$softing_row_overlayclr = $softing_row_overlay_type = $softing_bg_zindex = '';

$softing_md_hidebg = $softing_sm_hidebg = $softing_xs_hidebg = '';

$softing_md_css = $softing_sm_css = $softing_xs_css = '';
//extra row atts

$disable_element = '';
$output = $after_output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

wp_enqueue_script( 'wpb_composer_front_js' );


$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
	'row',
	$softing_row_prepad,
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);


//bg custom class
$css_classes[] = $softing_row_overflow != '' ? 'overflow_'.$softing_row_overflow : '';
$css_classes[] = $softing_bg_zindex != '' ? 'zindex'.$softing_bg_zindex : '';
$css_classes[] = $softing_parallax_bg_opacity != '' ? 'parallax-bg-opacity-'.$softing_parallax_bg_opacity : '';
$css_classes[] = $softing_md_hidebg != '' ? 'row-bg-image-hide-992' : '';
$css_classes[] = $softing_sm_hidebg != '' ? 'row-bg-image-hide-768' : '';
$css_classes[] = $softing_xs_hidebg != '' ? 'row-bg-image-hide-576' : '';



if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
	} else {
		return '';
	}
}

if (vc_shortcode_custom_css_has_property( $css, array('border', 'background') ) || $video_bg || $parallax) {
	$css_classes[]='vc_row-has-fill';
}

if (!empty($atts['gap'])) {
	$css_classes[] = 'vc_column-gap-'.$atts['gap'];
}


$wrapper_attributes = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
if ( ! empty( $full_width ) ) {
	if ( 'content_row' === $full_width ) {
	}else{
		$wrapper_attributes[] = 'data-vc-full-width="true"';
		$wrapper_attributes[] = 'data-vc-full-width-init="false"';
		if ( 'stretch_row_content' === $full_width ) {
			$wrapper_attributes[] = 'data-vc-stretch-content="true"';
		} elseif ( 'stretch_row_content_no_spaces' === $full_width ) {
			$wrapper_attributes[] = 'data-vc-stretch-content="true"';
			$css_classes[] = 'vc_row-no-padding';
		}
	}
	$after_output .= '<div class="vc_row-full-width vc_clearfix"></div>';
}

if ( ! empty( $full_height ) ) {
	$css_classes[] = 'vc_row-o-full-height';
	if ( ! empty( $columns_placement ) ) {
		$flex_row = true;
		$css_classes[] = 'vc_row-o-columns-' . $columns_placement;
		if ( 'stretch' === $columns_placement ) {
			$css_classes[] = 'vc_row-o-equal-height';
		}
	}
}

if ( ! empty( $equal_height ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-equal-height';
}

if ( ! empty( $content_placement ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-content-' . $content_placement;
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_row-flex';
}

$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

$parallax_speed = $parallax_speed_bg;
if ( $has_video_bg ) {
	$parallax = $video_bg_parallax;
	$parallax_speed = $parallax_speed_video;
	$parallax_image = $video_bg_url;
	$css_classes[] = 'vc_video-bg-container';
	wp_enqueue_script( 'vc_youtube_iframe_api_js' );
}


if ( ! empty( $parallax ) ) {

	//CUSTOM PARALLAX CODE START
	if ( ($parallax == 'softing-scroll' || $parallax == 'softing-scale' || $parallax == 'softing-opacity' || $parallax == 'softing-scroll-opacity' || $parallax == 'softing-scale-opacity' ) AND ( empty( $video_bg ) ) ) {
		//CUSTOM PARALLAX CODE START
		//wp_enqueue_script( 'softing-custom-parallax' );
		$softing_bgpos = $softing_bg_pos == 'custom' ? $softing_custom_bgpos : $softing_bg_pos;
		$softing_bgsize = $softing_bgsize == 'custom' ? $softing_custom_bgsize : $softing_bgsize;

		$wrapper_attributes[] = 'data-jarallax';
		$wrapper_attributes[] = $softing_parallax_speed ? 'data-speed="'.esc_attr($softing_parallax_speed).'"' : 'data-speed="0.2"';
		$wrapper_attributes[] = $softing_bgpos ? 'data-img-position="'.esc_attr( $softing_bgpos).'"' : 'data-img-position="center"';
		$wrapper_attributes[] = $softing_bgsize ? 'data-img-size="'.esc_attr( $softing_bgsize ).'"' : 'data-img-size="cover"';
		$wrapper_attributes[] = $softing_bgrepeat ? 'data-img-repeat="'.esc_attr( $softing_bgrepeat).'"' : 'data-img-repeat="no-repeat"';
		$wrapper_attributes[] = $softing_mobile_parallax ? 'data-mobile-parallax="'.esc_attr( $softing_mobile_parallax ).'"' : '';

		$css_classes[] = 'jarallax jarallax-bg jarallax-' . $parallax;

		if ( 'softing-scroll' ===  $parallax ) {
			$wrapper_attributes[] = 'data-type="scroll"';
			$css_classes[] = 'jarallax-bg-scroll mobile-parallax-'.$softing_mobile_parallax .'';
		}elseif ( 'softing-scale' ===  $parallax ) {
			$wrapper_attributes[] = 'data-type="scale"';
			$css_classes[] = 'jarallax-bg-scale mobile-parallax-'.$softing_mobile_parallax .'';
		}elseif ( 'softing-opacity' ===  $parallax ) {
			$wrapper_attributes[] = 'data-type="opacity"';
			$css_classes[] = 'jarallax-bg-opacity mobile-parallax-'.$softing_mobile_parallax .'';
		}elseif ( 'softing-scroll-opacity' ===  $parallax ) {
			$wrapper_attributes[] = 'data-type="scroll-opacity"';
			$css_classes[] = 'jarallax-bg-scroll-opacity mobile-parallax-'.$softing_mobile_parallax .'';
		}elseif ( 'softing-scale-opacity' ===  $parallax ) {
			$wrapper_attributes[] = 'data-type="scale-opacity"';
			$css_classes[] = 'jarallax-bg-scale-opacity mobile-parallax-'.$softing_mobile_parallax .'';
		}else {
			$wrapper_attributes[] = 'data-type="scroll"';
			$css_classes[] = 'jarallax-bg-scroll mobile-parallax-'.$softing_mobile_parallax .'';
		}
		//CUSTOM CODE END
	}else {
		wp_enqueue_script( 'vc_jquery_skrollr_js' );
		$wrapper_attributes[] = 'data-vc-parallax="' . esc_attr( $parallax_speed ) . '"'; // parallax speed
		$css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;
		if ( false !== strpos( $parallax, 'fade' ) ) {
			$css_classes[] = 'js-vc_parallax-o-fade';
			$wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
		} elseif ( false !== strpos( $parallax, 'fixed' ) ) {
			$css_classes[] = 'js-vc_parallax-o-fixed';

		}
	}
}


if ( ! empty( $parallax_image ) ) {
	if ( $has_video_bg ) {
		$parallax_image_src = $parallax_image;
	} else {
		$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
		$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );
		if ( ! empty( $parallax_image_src[0] ) ) {
			$parallax_image_src = $parallax_image_src[0];
		}
	}
	// CUSTOM CODE START
	if ( ($parallax == 'softing-scroll' || $parallax == 'softing-scale' || $parallax == 'softing-opacity' || $parallax == 'softing-scroll-opacity' || $parallax == 'softing-scale-opacity' ) AND (  $video_bg == '' ) ) {
		wp_enqueue_script( 'jarallax' );
		$wrapper_attributes[] = 'data-img-src="' . esc_attr( $parallax_image_src ) . '"';
	}else {
		$wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image_src ) . '"';
	}
	// CUSTOM CODE END
}

//craete uniq class for row data css
$unique_class = 'nt_row_1541'.mt_rand(15, 1000000000);
//add extra css to custom softing_vc_extra_css function
$softing_row_extra = array();
$softing_row_extra[] = $softing_row_overflow == 'visible' ? '.'.$unique_class.'{overflow:'.$softing_row_overflow.'!important;}' : '';
$softing_row_extra[] = $softing_row_overflow == 'visible' && $softing_bg_zindex != '' ? '.'.$unique_class.'{z-index:'.$softing_bg_zindex.'!important;}' : '';
$softing_row_extra[] = $softing_bg_attachment != '' ? '.'.$unique_class.'{background-attachment:'.$softing_bg_attachment.'!important;}' : '';
//add to custom css function
$softing_row_data = softing_vc_extra_css($atts, $unique_class, $softing_row_extra);
$css_classes[]= $softing_row_data != '' ? $unique_class : '';
$css_classes[] = $softing_row_data != '' ? 'nt_row-has-responsive-data' : '';

if ( ! $parallax && $has_video_bg ) {
	$wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
}

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="ult-responsive ' . esc_attr( trim( $css_class ) ) . '"';

// custom code start - for container
if ( 'stretch_row' === $full_width ) { $output .= '<div class="container">'; }
if ( 'clear_layout' === $full_width ) { $output .= '<div class="none-container">'; }
if ( empty($full_width) ) { $output .= '<div class="container">'; }
// custom code end - for container

$output .= '<div ' . implode( ' ', $wrapper_attributes ) .$softing_row_data.'>';

// custom code start - for row_overlay
if($softing_row_overlay_type == 'custom' && $softing_row_overlayclr != '' ){
$output .= '<div class="vc_row_overlay_clr" style="background-color:'.$softing_row_overlayclr.'"></div>';
}
if( $softing_row_overlay_type == 'pattern-black' || $softing_row_overlay_type == 'pattern-white' ){
$output .= '<div class="vc_row_overlay_clr '.$softing_row_overlay_type.'"></div>';
}
// custom code end - for row_overlay

$output .= wpb_js_remove_wpautop( $content );

if(function_exists('softing_vc_row_divider') ){
	$output .= softing_vc_row_divider($atts);
}
$output .= '</div>';

if ( empty($full_width) ) { $output .= '</div>'; } // custom line start - for container

$output .= $after_output;

if ( 'stretch_row' === $full_width ) { $output .= '</div>'; } // custom line start - for container
if ( 'clear_layout' === $full_width ) { $output .= '</div>'; } // custom line start - for container

echo softing_vc_sanitize_data( $output );
