<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $source
 * @var $text
 * @var $link
 * @var $google_fonts
 * @var $font_container
 * @var $el_class
 * @var $el_id
 * @var $css
 * @var $css_animation
 * @var $font_container_data - returned from $this->getAttributes
 * @var $google_fonts_data - returned from $this->getAttributes
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Custom_heading
 */
$source = $text = $link = $google_fonts = $font_container = $el_id = $el_class = $css = $css_animation = $font_container_data = $google_fonts_data = array();
// This is needed to extract $font_container_data and $google_fonts_data
extract( $this->getAttributes( $atts ) );

//extra vc_heading atts
$softing_ch_family = $softing_ch_fw = $softing_ch_trans = $softing_ch_fsz = $softing_ch_bclr = $softing_ch_lts = $softing_ch_wrds = $softing_ch_premarb = '';

$res_md_align = $res_md_ch_fs = $res_md_lh = $res_md_lts  = $res_sm_align = $res_sm_ch_fs = $res_sm_lh= $res_sm_lts =  '';

$softing_md_css = $softing_sm_css = $softing_xs_css = '';

$softing_lg_bgpos = $softing_lgcustom_bgpos = $softing_md_bgpos = $softing_md_custom_bgpos = $softing_sm_bgpos = $softing_sm_custom_bgpos = $softing_xs_bgpos = $softing_xs_custom_bgpos = '';

$md_custom_media = $md_custom_css_media = $sm_custom_media = $sm_custom_css_media = $xs_custom_media = $xs_custom_css_media = '';
//extra vc_heading atts

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

/**
 * @var $css_class
 */
extract( $this->getStyles( $el_class . $this->getCSSAnimation( $css_animation ), $css, $google_fonts_data, $font_container_data, $atts ) );

$settings = get_option( 'wpb_js_google_fonts_subsets' );
if ( is_array( $settings ) && ! empty( $settings ) ) {
	$subsets = '&subset=' . implode( ',', $settings );
} else {
	$subsets = '';
}

if ( ( ! isset( $atts['use_theme_fonts'] ) || 'yes' !== $atts['use_theme_fonts'] ) && isset( $google_fonts_data['values']['font_family'] ) ) {
	wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $google_fonts_data['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $google_fonts_data['values']['font_family'] . $subsets );
}

if ( ! empty( $styles ) ) {
	$style = 'style="' . esc_attr( implode( ';', $styles ) ) . '"';
} else {
	$style = '';
}

if ( 'post_title' === $source ) {
	$text = get_the_title( get_the_ID() );
}

if ( ! empty( $link ) ) {
	$link = vc_build_link( $link );
	$text = '<a href="' . esc_attr( $link['url'] ) . '"' . ( $link['target'] ? ' target="' . esc_attr( $link['target'] ) . '"' : '' ) . ( $link['rel'] ? ' rel="' . esc_attr( $link['rel'] ) . '"' : '' ) . ( $link['title'] ? ' title="' . esc_attr( $link['title'] ) . '"' : '' ) . '>' . $text . '</a>';
}
$wrapper_attributes = array();
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}


$unique_ch_class = 'nt_ch_1541'.mt_rand(15, 1000000000);
//
$vc_style = ! empty( $styles ) ? '.'.$unique_ch_class.'{ '.esc_attr( implode( ';', $styles ) ).'}' : '';
$lg_lts = $softing_ch_lts != '' ? '.'.$unique_ch_class.'{letter-spacing:'.esc_attr($softing_ch_lts).';}' : '';
$lg_wrds = $softing_ch_wrds != '' ? '.'.$unique_ch_class.'{word-spacing:'.esc_attr($softing_ch_wrds).';}' : '';
$bold_t_clr = $softing_ch_bclr != '' ? '.'.$unique_ch_class.' b{color:'.esc_attr($softing_ch_bclr).';}' : '';

//992px
$fmd_media = $md_custom_media == 'yes' && $md_custom_css_media != '' ? $md_custom_css_media : '@media (max-width: 992px)';
$md_font = array();
$md_font[] 	= $res_md_align != '' ? 'text-align:'.esc_attr($res_md_align).'!important;' : '';
$md_font[] 	= $res_md_ch_fs != '' ? 'font-size:'.esc_attr($res_md_ch_fs).'!important;' : '';
$md_font[] 	= $res_md_lh  	!= '' ? 'line-height:'.esc_attr($res_md_lh).'!important;' : '';
$md_font[] 	= $res_md_lts  	!= '' ? 'letter-spacing:'.esc_attr($res_md_lts).'!important;' : '';
$md_font  = !empty($md_font) ? implode( ' ', array_filter( $md_font ) ) : '';
//768px
$fsm_media = $sm_custom_media == 'yes' && $sm_custom_css_media != '' ? $sm_custom_css_media : '@media (max-width: 768px)';
$sm_font = array();
$sm_font[] 	= $res_sm_align != '' ? 'text-align:'.esc_attr($res_sm_align).'!important;' : '';
$sm_font[] 	= $res_sm_ch_fs != '' ? 'font-size:'.esc_attr($res_sm_ch_fs).'!important;' : '';
$sm_font[] 	= $res_sm_lh    != '' ? 'line-height:'.esc_attr($res_sm_lh).'!important;' : '';
$sm_font[] 	= $res_sm_lts   != '' ? 'letter-spacing:'.esc_attr($res_sm_lts).'!important;' : '';
$sm_font  = !empty($sm_font) ? implode( ' ', array_filter( $sm_font ) ) : '';

//576px
$fxs_media = $xs_custom_media == 'yes' && $xs_custom_css_media != '' ? $xs_custom_css_media : '@media (max-width: 576px)';
$xs_font = array();
$xs_font[] 	= $res_xs_align != '' ? 'text-align:'.esc_attr($res_xs_align).'!important;' : '';
$xs_font[] 	= $res_xs_ch_fs != '' ? 'font-size:'.esc_attr($res_xs_ch_fs).'!important;' : '';
$xs_font[] 	= $res_xs_lh    != '' ? 'line-height:'.esc_attr($res_xs_lh).'!important;' : '';
$xs_font[] 	= $res_xs_lts   != '' ? 'letter-spacing:'.esc_attr($res_xs_lts).'!important;' : '';
$xs_font  = !empty($xs_font) ? implode( ' ', array_filter( $xs_font ) ) : '';


//create responsive media from css
$softing_ch_extra = array();
$softing_ch_extra[]  = $vc_style;
$softing_ch_extra[]  = $lg_lts;
$softing_ch_extra[]  = $lg_wrds;
$softing_ch_extra[]  = $bold_t_clr;
$softing_ch_extra[]  = $md_font != '' ? $fmd_media.' {.'.$unique_ch_class.'{'.$md_font.'}}' : '';
$softing_ch_extra[]  = $sm_font != '' ? $fsm_media.' {.'.$unique_ch_class.'{'.$sm_font.'}}' : '';
$softing_ch_extra[]  = $xs_font != '' ? $fxs_media.' {.'.$unique_ch_class.'{'.$xs_font.'}}' : '';
//add to custom css function
$softing_data = softing_vc_extra_css($atts, $unique_ch_class, $softing_ch_extra);

$softing_vch_classes = $softing_data != '' ? array($unique_ch_class, $softing_ch_family, $softing_ch_trans, $softing_ch_fw, $softing_ch_fsz, $softing_ch_premarb, $css_class) : array($softing_ch_family, $softing_ch_trans, $softing_ch_fw, $softing_ch_fsz, $softing_ch_premarb, $css_class);


$output = '';

if ( apply_filters( 'vc_custom_heading_template_use_wrapper', false ) ) {
	$output .= '<div class="' . implode( ' ', array_filter( array_unique( $softing_vch_classes ) ) ) . '" ' . implode( ' ', $wrapper_attributes ) .$softing_data. '>';
	$output .= '<' . $font_container_data['values']['tag'] . '>';
	$output .= $text;
	$output .= '</' . $font_container_data['values']['tag'] . '>';
	$output .= '</div>';
} else {

	$output .= '<' . $font_container_data['values']['tag'] . ' class="' . implode( ' ', array_filter( array_unique( $softing_vch_classes ) ) ) . '" ' . implode( ' ', $wrapper_attributes ) .$softing_data. '>';
	$output .= $text;
	$output .= '</' . $font_container_data['values']['tag'] . '>';
}

echo softing_vc_sanitize_data( $output );
