<?php


/**
* ReduxFramework Theme Config File
* For full documentation, please visit: http://docs.reduxframework.com/
*/

if ( ! class_exists( 'Redux' ) ) {
    return;
}

// define directories
define( 'SOFTING_OPTIONS_PATH', get_template_directory_uri() . '/inc/theme-options/' );


// This is your option name where all the Redux data is stored.
$softing_pre = "softing";

/**
* ---> SET ARGUMENTS
* All the possible arguments for Redux.
* For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
* */

$softing_theme = wp_get_theme(); // For use with some settings. Not necessary.

$softing_options_args = array(
    // TYPICAL -> Change these values as you need/desire
    'softing_pre' => $softing_pre,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $softing_theme->get( 'Name' ),
    // Name that appears at the top of your panel
    'display_version' => $softing_theme->get( 'Version' ),
    // Version that appears at the top of your panel
    'menu_type' => 'submenu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => false,
    // Show the sections below the admin menu item or not
    'menu_title' => esc_html__( 'Theme Options', 'softing' ),
    'page_title' => esc_html__( 'Theme Options', 'softing' ),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key' => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography' => false,
    'admin_bar' => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority' => 50,
    // Choose an priority for the admin bar menu
    'global_variable' => 'softing',
    // Set a different name for your global variable other than the softing_pre
    'dev_mode' => false,
    'update_notice' => false,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,

    // OPTIONAL -> Give you extra features
    'page_priority' => 99,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'ninetheme_theme_manage',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon' => '',
    // Specify a custom URL to an icon
    'last_tab' => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug' => '',
    // Page slug used to denote the panel, will be based off page title then menu title then softing_pre if not provided
    'save_defaults' => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show' => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark' => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database' => '',
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints' => array(
        'icon' => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color' => 'lightgray',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'dark',
            'shadow' => true,
            'rounded' => false,
            'style' => '',
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect' => array(
            'show' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'mouseover',
            ),
            'hide' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'click mouseleave',
            ),
        ),
    )
);

// ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
$softing_options_args['admin_bar_links'][] = array(
    'id' => 'ninetheme-softing-docs',
    'href' => 'https://ninetheme.com/documentations',
    'title' => esc_html__( 'Softing Documentation', 'softing' ),
);
$softing_options_args['admin_bar_links'][] = array(
    'id' => 'ninetheme-support',
    'href' => 'https://ninetheme.com/contact',
    'title' => esc_html__( 'Support', 'softing' ),
);
$softing_options_args['admin_bar_links'][] = array(
    'id' => 'ninetheme-portfolio',
    'href' => 'https://ninetheme.com/wordpress-themes',
    'title' => esc_html__( 'NineTheme Portfolio', 'softing' ),
);

// Add content after the form.
$softing_options_args['footer_text'] = esc_html__( 'If you need help please open a ticket on our support center.', 'softing' );

Redux::setArgs( $softing_pre, $softing_options_args );

/* END ARGUMENTS */

/* START SECTIONS */


/*************************************************
## MAIN SETTING SECTION
*************************************************/
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Main Setting', 'softing' ),
    'id' => 'basic',
    'desc' => esc_html__( 'These are main settings for general theme!', 'softing' ),
    'customizer_width' => '400px',
    'icon' => 'el el-cog',
));

//COLORS SETTINGS SUBSECTION
Redux::setSection( $softing_pre, array(
    'title' => esc_html__( 'Theme Colors', 'softing' ),
    'id' => 'themecolorssubsection',
    'icon' => 'el el-brush',
    'subsection' => true,
    'fields' => array(
        array(
            'title' => esc_html__( 'Main Color', 'softing' ),
            'id' => 'theme_main_color',
            'type' => 'color',
            'default' => ''
        ),
        array(
            'title' => esc_html__( 'Secondary Color', 'softing' ),
            'id' => 'theme_secondary_color',
            'type' => 'color',
            'default' => ''
        ),
)));
//BREADCRUMBS SETTINGS SUBSECTION
Redux::setSection( $softing_pre, array(
    'title' => esc_html__( 'Breadcrumbs', 'softing' ),
    'id' => 'themebreadcrumbssubsection',
    'icon' => 'el el-idea-alt',
    'subsection' => true,
    'customizer_width' => '450px',
    'fields' => array(
        array(
            'title' => esc_html__( 'Breadcrumbs', 'softing' ),
            'subtitle' => esc_html__( 'Switch On-off', 'softing' ),
            'desc' => esc_html__( 'If enabled, adds breadcrumbs navigation to bottom of page title.', 'softing' ),
            'id' => 'breadcrumbs',
            'type' => 'switch',
            'default' => false,
        ),
        array(
            'title' => esc_html__( 'Breadcrumbs Typography', 'softing' ),
            'id' => 'breadcrumbs_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '.nt-breadcrumbs, .nt-breadcrumbs a' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'breadcrumbs', '=', '1' ),
        ),
    )
));
//PRELOADER SETTINGS SUBSECTION
Redux::setSection( $softing_pre, array(
    'title' => esc_html__( 'Preloader', 'softing' ),
    'id' => 'themepreloadersubsection',
    'icon' => 'el el-brush',
    'subsection' => true,
    'fields' => array(
        array(
            'title' => esc_html__( 'Preloader', 'softing' ),
            'subtitle' => esc_html__( 'Switch On-off', 'softing' ),
            'desc' => esc_html__( 'If enabled, adds preloader.', 'softing' ),
            'id' => 'pre_onoff',
            'type' => 'switch',
            'default' => true,
        ),
        array(
            'title' => esc_html__( 'Preloader Type', 'softing' ),
            'subtitle' => esc_html__( 'Select your preloader type.', 'softing' ),
            'id' => 'pre_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'default' => 'Default',
                '01' => 'Type 1',
                '02' => 'Type 2',
                '03' => 'Type 3',
                '04' => 'Type 4',
                '05' => 'Type 5',
                '06' => 'Type 6',
                '07' => 'Type 7',
                '08' => 'Type 8',
                '09' => 'Type 9',
                '10' => 'Type 10',
                '11' => 'Type 11',
                '12' => 'Type 12',
            ),
            'default' => 'default',
            'required' => array( 'pre_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Preloader Background Color', 'softing' ),
            'desc' => esc_html__( 'Add preloader background color.', 'softing' ),
            'id' => 'pre_bg',
            'type' => 'color',
            'default' => '',
            'required' => array( array( 'pre_onoff', '=', '1' ), array( 'pre_type', '!=', 'default' ), array( 'pre_type', '!=', '' ) ),
        ),
        array(
            'title' => esc_html__( 'Preloader Spin Color', 'softing' ),
            'desc' => esc_html__( 'Add preloader spin color.', 'softing' ),
            'id' => 'pre_spin',
            'type' => 'color',
            'default' => '',
            'required' => array( array( 'pre_onoff', '=', '1' ), array( 'pre_type', '!=', 'default' ), array( 'pre_type', '!=', '' ) ),
        ),
    )
));
//MAIN THEME TYPOGRAPHY SUBSECTION
Redux::setSection( $softing_pre, array(
    'title' => esc_html__( 'Typograhy General', 'softing' ),
    'id' => 'themetypographysection',
    'icon' => 'el el-fontsize',
    'subsection' => true,
    'fields' => array(
        array(
            'title' => esc_html__( 'Body - General ', 'softing' ),
            'subtitle' => esc_html__("Choose typo for body", 'softing'),
            'id' => 'font_body',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'body' ),
            'default' => array(
                'font-family' =>'',
                'color' =>"",
                'font-style' =>'',
                'font-size' =>'',
                'line-height' =>'',
            ),
        ),
        array(
            'title' => esc_html__( 'Button', 'softing' ),
            'subtitle' => esc_html__("Choose typo for button", 'softing'),
            'id' => 'font_btn',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '.btn' ),
            'default' => array(
                'font-family' =>'',
                'color' =>"",
                'font-style' =>'',
                'font-size' =>'',
                'line-height' =>'',
            ),
        ),
        array(
            'title' => esc_html__( 'H1 Headings', 'softing' ),
            'subtitle' => esc_html__("Choose typo for h1", 'softing'),
            'id' => 'font_h1',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'h1' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
        ),
        array(
            'title' => esc_html__( 'H2 Headings', 'softing' ),
            'subtitle' => esc_html__("Choose typo for h2", 'softing'),
            'id' => 'font_h2',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'h2' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
        ),
        array(
            'title' => esc_html__( 'H3 Headings', 'softing' ),
            'subtitle' => esc_html__("Choose typo for h3", 'softing'),
            'id' => 'font_h3',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'h3' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
        ),
        array(
            'title' => esc_html__( 'H4 Headings', 'softing' ),
            'subtitle' => esc_html__("Choose typo for h4", 'softing'),
            'id' => 'font_h4',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'h4' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
        ),
        array(
            'title' => esc_html__( 'H5 Headings', 'softing' ),
            'subtitle' => esc_html__("Choose typo for h5", 'softing'),
            'id' => 'font_h5',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'h5' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
        ),
        array(
            'title' => esc_html__( 'H6 Headings', 'softing' ),
            'subtitle' => esc_html__("Choose typo for h6", 'softing'),
            'id' => 'font_h6',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'h6' ),
            'units' => 'px',
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
        ),
        array(
            'title' => esc_html__( 'Paragraph p element', 'softing' ),
            'subtitle' => esc_html__("Choose typo for paragraph", 'softing'),
            'id' => 'font_p',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'p' ),
            'default' => array(
                'font-family' =>'',
                'color' =>"",
                'font-style' =>'',
                'font-size' =>'',
                'line-height' =>'',
            ),
        ),
        array(
            'title' => esc_html__( 'Html a element', 'softing' ),
            'subtitle' => esc_html__("Choose typo for a element", 'softing'),
            'id' => 'font_a',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( 'a' ),
            'default' => array(
                'font-family' =>'',
                'color' =>"",
                'font-style' =>'',
                'font-size' =>'',
                'line-height' =>'',
            ),
        ),
    )
));
//BACKTOTOP BUTTON SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Back-to-top Button', 'softing' ),
    'id' => 'backtotop',
    'icon' => 'el el-brush',
    'subsection' => true,
    'fields' => array(
        array(
            'title' => esc_html__( 'Back-to-top', 'softing' ),
            'subtitle' => esc_html__( 'Switch On-off', 'softing' ),
            'desc' => esc_html__( 'If enabled, adds preloader.', 'softing' ),
            'id' => 'backtotop_onoff',
            'type' => 'switch',
            'default' => true,
        ),
        array(
            'title' => esc_html__( 'Back-to-top Background', 'softing' ),
            'id' => 'backtotop_bg',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '#scrollUp' ),
            'default' =>  '#4ac4f3',
            'required' => array( 'backtotop_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Back-to-top Icon', 'softing' ),
            'id' => 'backtotop_icon',
            'type' => 'color',
            'default' =>  '#fff',
            'output' => array( '#scrollUp i' ),
            'required' => array( 'backtotop_onoff', '=', '1' ),
        ),
    )
));
// THEME PAGINATION SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Pagination', 'softing' ),
    'desc' => esc_html__( 'These are main settings for general theme!', 'softing' ),
    'id' => 'pagination',
    'subsection' => true,
    'icon' => 'el el-link',
    'fields' => array(
        array(
            'title' => esc_html__( 'Pagination', 'softing' ),
            'subtitle' => esc_html__( 'Switch On-off', 'softing' ),
            'desc' => esc_html__( 'If enabled, adds pagination.', 'softing' ),
            'id' => 'pag_onoff',
            'type' => 'switch',
            'default' => true,
        ),
        array(
            'title' => esc_html__( 'Pagination Type', 'softing' ),
            'subtitle' => esc_html__( 'Select type.', 'softing' ),
            'id' => 'pag_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'default' => 'Default',
                'outline' => 'Outline',
            ),
            'default' => 'default'
        ),
        array(
            'title' => esc_html__( 'Pagination size', 'softing' ),
            'subtitle' => esc_html__( 'Select size.', 'softing' ),
            'id' => 'pag_size',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'small' => 'small',
                'medium' => 'medium',
                'large' => 'large',
            ),
            'default' => 'medium'
        ),
        array(
            'title' => esc_html__( 'Pagination group', 'softing' ),
            'subtitle' => esc_html__( 'Select group.', 'softing' ),
            'id' => 'pag_group',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'yes' => 'yes',
                'no' => 'no',
            ),
            'default' => 'no'
        ),
        array(
            'title' => esc_html__( 'Pagination corner', 'softing' ),
            'subtitle' => esc_html__( 'Select corner type.', 'softing' ),
            'id' => 'pag_corner',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'square' => 'square',
                'rounded' => 'rounded',
                'circle' => 'circle',
            ),
            'default' => 'square'
        ),
        array(
            'title' => esc_html__( 'Pagination align', 'softing' ),
            'subtitle' => esc_html__( 'Select align.', 'softing' ),
            'id' => 'pag_align',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'left' => 'left',
                'right' => 'right',
                'center' => 'center',
            ),
            'default' => 'left'
        ),
        array(
            'title' => esc_html__( 'Pagination default/outline color', 'softing' ),
            'id' => 'pag_clr',
            'type' => 'color',
            'mode' => 'color',

        ),
        array(
            'title' => esc_html__( 'Active and Hover pagination color', 'softing' ),
            'id' => 'pag_hvrclr',
            'type' => 'color',
            'mode' => 'color',
        ),
        array(
            'title' => esc_html__( 'Pagination number color', 'softing' ),
            'id' => 'pag_nclr',
            'type' => 'color',
            'mode' => 'color',
        ),
        array(
            'title' => esc_html__( 'Active and Hover pagination number color', 'softing' ),
            'id' => 'pag_hvrnclr',
            'type' => 'color',
            'mode' => 'color',
        ),
    )
));
/*************************************************
## HEADER & NAV SECTION
*************************************************/
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Header', 'softing' ),
    'id' => 'headersection',
    'icon' => 'el el-lines',
));
//HEADER MENU
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Header Menu', 'softing' ),
    'id' => 'headernavsection',
    'subsection' => true,
    'icon' => 'el el-brush',
    'fields' => array(
        array(
            'title' => esc_html__( 'Menu Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site navigation.', 'softing' ),
            'id' => 'nav_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Header Navigation Background Type', 'softing' ),
            'id' => 'nav_bg_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'normal' => esc_html__( 'White background', 'softing' ),
                'trans' => esc_html__( 'Transparent', 'softing' ),
                'fixed' => esc_html__( 'Fixed No Background', 'softing' ),
            ),
            'default' => 'normal',
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Menu Background Customize', 'softing' ),
            'id' => 'nav_bg',
            'type' => 'color_rgba',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav, .nt-site-header nav.navbar.bootsnav.navbar-transparent.white' ),
            'default' => array(
                'color' => '',
                'alpha' => 1
            ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Primary Menu Font', 'softing' ),
            'subtitle' => esc_html__("Choose typo for primary menu", 'softing'),
            'id' => 'nav_a_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '.nt-site-header nav.navbar.bootsnav.navbar-default ul.nav > li > a' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Hover Menu Item Color', 'softing' ),
            'desc' => esc_html__( 'Set your own hover color for the navigation menu item.', 'softing' ),
            'id' => 'nav_hvr_a',
            'type' => 'color_rgba',
            'output' => array( '.nt-site-header nav.navbar.bootsnav ul.nav > li > a:hover' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Menu Item Background Color', 'softing' ),
            'desc' => esc_html__( 'Set your own background-color for the navigation menu item.', 'softing' ),
            'id' => 'nav_a_bg',
            'type' => 'color_rgba',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav.navbar-default ul.nav > li > a' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Hover Menu Item Background Color', 'softing' ),
            'desc' => esc_html__( 'Set your own hover background-color for the navigation menu item.', 'softing' ),
            'id' => 'nav_hvr_a_bg',
            'type' => 'color_rgba',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav.navbar-default ul.nav > li > a:hover' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Sticky Menu Background', 'softing' ),
            'id' => 'nav_bg_sticky',
            'type' => 'color_rgba',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav.sticked, .nt-site-header nav.navbar.bootsnav.fixed-style:not(.no-background), .nt-site-header nav.navbar.bootsnav.transparent-style:not(.navbar-transparent)' ),
            'default' => array(
                'color' => '',
                'alpha' => 1
            ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Sticky Menu Item Color', 'softing' ),
            'id' => 'nav_bg_sticky_i',
            'type' => 'color_rgba',
            'mode' => 'color',
            'output' => array( '.nt-site-header nav.navbar.bootsnav.sticked ul.nav > li > a, .nt-site-header nav.navbar.bootsnav.fixed-style:not(.no-background) ul.nav > li > a, .nt-site-header nav.navbar.bootsnav.transparent-style:not(.navbar-transparent) ul.nav > li > a' ),
            'default' => array(
                'color' => '',
                'alpha' => 1
            ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Dropdown Background Color', 'softing' ),
            'desc' => esc_html__( 'Set your own background-color for the navigation dropdown menu.', 'softing' ),
            'id' => 'nav_drop_bg',
            'type' => 'color_rgba',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav li.dropdown ul.dropdown-menu' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Dropdown Item Color', 'softing' ),
            'desc' => esc_html__( 'Set your own color for the navigation dropdown menu item.', 'softing' ),
            'id' => 'nav_drop_i',
            'type' => 'color_rgba',
            'mode' => 'color',
            'output' => array( '.nt-site-header nav.navbar.bootsnav ul.navbar-right li.dropdown ul.dropdown-menu li a' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Dropdown Hover Item Color', 'softing' ),
            'desc' => esc_html__( 'Set your own hover color for the navigation dropdown menu item.', 'softing' ),
            'id' => 'nav_drop_ihvr',
            'type' => 'color_rgba',
            'mode' => 'color',
            'output' => array( '.nt-site-header nav.navbar.bootsnav ul.navbar-right li.dropdown ul.dropdown-menu li a:hover' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Dropdown Hover Item Background', 'softing' ),
            'desc' => esc_html__( 'Set your own hover background-color for the navigation dropdown menu item.', 'softing' ),
            'id' => 'nav_drop_ihvrbg',
            'type' => 'color_rgba',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav ul.navbar-right li.dropdown ul.dropdown-menu li a:hover' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Dropdown Menu Item Font', 'softing' ),
            'subtitle' => esc_html__("Choose typo for dropdown menu item", 'softing'),
            'id' => 'nav_drop_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '.nt-site-header nav.navbar.bootsnav ul.navbar-right li.dropdown ul.dropdown-menu li a' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Toggle Button Bar Color', 'softing' ),
            'desc' => esc_html__( 'Set your own color for mobile menu navbar toggle button.', 'softing' ),
            'id' => 'nav_icon',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav .navbar-toggle .fa-bars' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Hover Toggle Button Bar Color', 'softing' ),
            'desc' => esc_html__( 'Set your own hover color for mobile menu navbar toggle button.', 'softing' ),
            'id' => 'nav_icon_hvr',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav .navbar-toggle:hover .fa-bars' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Toggle Button Close Color', 'softing' ),
            'desc' => esc_html__( 'Set your own color for mobile menu navbar toggle close button.', 'softing' ),
            'id' => 'nav_icon_close',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav .navbar-toggle:hover .fa-times' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Hover Toggle Button Close Color', 'softing' ),
            'desc' => esc_html__( 'Set your own hover color for mobile menu navbar toggle close button.', 'softing' ),
            'id' => 'nav_icon_close',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav .navbar-toggle:hover .fa-times' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Toggle Button Border', 'softing' ),
            'id' => 'nav_icon_brd',
            'type' => 'border',
            'all' => false,
            'default' => array(
                'border-color' => '',
                'border-style' => '',
                'border-top' => '',
                'border-right' => '',
                'border-bottom' => '',
                'border-left' => ''
            ),
            'output' => array( '.nt-site-header nav.navbar.bootsnav .navbar-toggle' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Toggle Button Background Color', 'softing' ),
            'desc' => esc_html__( 'Set your own background color for mobile menu navbar toggle button.', 'softing' ),
            'id' => 'nav_icon_bg',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav .navbar-toggle' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Hover Toggle Button Background Color', 'softing' ),
            'desc' => esc_html__( 'Set your own hover background color for mobile menu navbar toggle button.', 'softing' ),
            'id' => 'nav_icon_hvrbg',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.nt-site-header nav.navbar.bootsnav .navbar-toggle:hover' ),
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        //information on-off
        array(
            'id' =>'info_nav0',
            'type' => 'info',
            'style' => 'success',
            'title' => esc_html__('Success!', 'softing'),
            'icon' => 'el el-info-circle',
            'customizer'=> false,
            'desc' => sprintf(esc_html__('%s is disabled on the site. Please activate to view options.', 'softing'),'<b>Navigation</b>'),
            'required' => array( 'nav_onoff', '=', '0' ),
        ),
    )
));
//HEADER RIGHT BUTTON
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Header Right Button', 'softing' ),
    'id' => 'headernavbtnsubsection',
    'subsection' => true,
    'icon' => 'el el-brush',
    'fields' => array(
        //
        array(
            'title' => esc_html__( 'Header Right Buttons Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site header right section buttons with switch option.', 'softing' ),
            'id' => 'nav_btn_onoff',
            'type' => 'switch',
            'default' => 0,
            'on' => 'On',
            'off' => 'Off',
            'required' => array( 'nav_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'First Button Title', 'softing' ),
            'subtitle' => esc_html__( 'Add button title.', 'softing' ),
            'id' => 'nav_btn1_title',
            'type' => 'text',
            'default' => 'Buy Ticket',
            'validate' => 'html_custom',
            'allowed_html' => array(
                'i' => array(
                    'class' => array(),
                    'style' => array()
                ),
                'span' => array(
                    'class' => array(),
                    'style' => array()
                )
            ),
            'default' => '',
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'First Button URL', 'softing' ),
            'subtitle' => esc_html__( 'Add button URL/Link.', 'softing' ),
            'id' => 'nav_btn1_url',
            'type' => 'text',
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'First Button Target', 'softing' ),
            'id' => 'nav_btn1_target',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                '' => esc_html__( 'Select Button Target Type', 'softing' ),
                '_blank' => esc_html__( 'Blank', 'softing' ),
                '_parent' => esc_html__( 'Parent', 'softing' ),
                '_self' => esc_html__( 'Self', 'softing' ),
                '_top' => esc_html__( 'Top', 'softing' ),
            ),
            'default' => '',
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'First Button Background Color', 'softing' ),
            'id' => 'nav_btn1_bg',
            'type' => 'color_rgba',
            'mode' => 'background-color',
            'output' => array( '.nt-site-header .attr-nav > ul > li:first-child > a' ),
            'default' => array(
                'color' => '',
                'alpha' => 1
            ),
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'First Button Hover Background Color', 'softing' ),
            'id' => 'nav_btn1_hvrbg',
            'type' => 'color_rgba',
            'mode' => 'background-color',
            'output' => array( '.nt-site-header .attr-nav > ul > li:first-child > a:hover' ),
            'default' => array(
                'color' => '',
                'alpha' => 1
            ),
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'First Button Title Color', 'softing' ),
            'id' => 'nav_btn1_clr',
            'type' => 'color',
            'mode' => 'color',
            'output' => array( '.nt-site-header .attr-nav > ul > li:first-child > a' ),
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'First Hover Title Color', 'softing' ),
            'id' => 'nav_btn1_hvrclr',
            'type' => 'color',
            'mode' => 'color',
            'output' => array( '.nt-site-header .attr-nav > ul > li:first-child > a:hover' ),
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        //nav second button
        array(
            'title' => esc_html__( 'Second Button Title', 'softing' ),
            'subtitle' => esc_html__( 'Add button title.', 'softing' ),
            'id' => 'nav_btn2_title',
            'type' => 'text',
            'default' => 'Buy Ticket',
            'validate' => 'html_custom',
            'allowed_html' => array(
                'i' => array(
                    'class' => array(),
                    'style' => array()
                ),
                'span' => array(
                    'class' => array(),
                    'style' => array()
                )
            ),
            'default' => '',
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'Second Button URL', 'softing' ),
            'subtitle' => esc_html__( 'Add button URL/Link.', 'softing' ),
            'id' => 'nav_btn2_url',
            'type' => 'text',
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'First Button Target', 'softing' ),
            'id' => 'nav_btn2_target',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                '' => esc_html__( 'Select Button Target Type', 'softing' ),
                '_blank' => esc_html__( 'Blank', 'softing' ),
                '_parent' => esc_html__( 'Parent', 'softing' ),
                '_self' => esc_html__( 'Self', 'softing' ),
                '_top' => esc_html__( 'Top', 'softing' ),
            ),
            'default' => '',
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'Second Button Background Color', 'softing' ),
            'id' => 'nav_btn2_bg',
            'type' => 'color_rgba',
            'mode' => 'background-color',
            'output' => array( '.nt-site-header .attr-nav > ul > li:last-child > a' ),
            'default' => array(
                'color' => '',
                'alpha' => 1
            ),
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'Second Button Hover Background Color', 'softing' ),
            'id' => 'nav_btn2_hvrbg',
            'type' => 'color_rgba',
            'mode' => 'background-color',
            'output' => array( '.nt-site-header .attr-nav > ul > li:last-child > a:hover' ),
            'default' => array(
                'color' => '',
                'alpha' => 1
            ),
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'Second Button Title Color', 'softing' ),
            'id' => 'nav_btn2_clr',
            'type' => 'color',
            'mode' => 'color',
            'output' => array( '.nt-site-header .attr-nav > ul > li:last-child > a' ),
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),
        array(
            'title' => esc_html__( 'Second Button Hover Title Color', 'softing' ),
            'id' => 'nav_btn2_hvrclr',
            'type' => 'color',
            'mode' => 'color',
            'output' => array( '.nt-site-header .attr-nav > ul > li:last-child > a:hover' ),
            'required' => array( array( 'nav_onoff', '=', '1' ), array( 'nav_btn_onoff', '=', '1' ) ),
        ),

        //information on-off
        array(
            'id' =>'info_nav_btn0',
            'type' => 'info',
            'style' => 'success',
            'title' => esc_html__('Success!', 'softing'),
            'icon' => 'el el-info-circle',
            'customizer'=> false,
            'desc' => sprintf(esc_html__('%s is disabled on the site header. Please activate to view options.', 'softing'),'<b>Header right buttons</b>'),
            'required' => array( 'nav_allbtn_onoff', '=', '0' ),
        ),
    )
));
/*************************************************
## LOGO SECTION
*************************************************/
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Logo', 'softing' ),
    'desc' => esc_html__( 'These are main settings for general theme!', 'softing' ),
    'id' => 'logosection',
    'customizer_width' => '400px',
    'icon' => 'el el-star-empty',
    'fields' => array(
        array(
            'title' => esc_html__( 'Logo Type', 'softing' ),
            'subtitle' => esc_html__( 'Select your footer logo type.', 'softing' ),
            'id' => 'logo_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'img' => 'Image Logo',
                'sitename' => 'Site name',
                'customtext'=> 'Custom Text',
            ),
            'default' => 'img'
        ),
        array(
            'title' => esc_html__( 'Custom text for logo', 'softing' ),
            'desc' => esc_html__( 'Text entered here will be used as logo', 'softing' ),
            'id' => 'text_logo',
            'type' => 'text',
            'required' => array( 'logo_type', '=', 'customtext' ),
        ),
        array(
            'title' => esc_html__('Sitename or Custom Text Logo Font', 'softing'),
            'desc' => esc_html__("Choose typo your sitename, if you don't use an image logo.", 'softing'),
            'id' =>'logo_style',
            'type' => 'typography',
            'font-family' => true,
            'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup' => false, // Select a backup non-google font in addition to a google font
            'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets' => true, // Only appears if google is true and subsets not set to false
            'font-size' => true,
            'line-height' => true,
            'text-align' => false,
            'customizer' => true,
            'color' => true,
            'preview' => true, // Disable the previewer
            'output' => array('header #logo a.brand'),
            'default' => array(
                'font-family' =>'',
                'color' =>"",
                'font-style' =>'',
                'font-size' =>'',
                'line-height' =>'',
            ),
            'required' => array( array( 'logo_type', '!=', 'img' ),array( 'logo_type', '!=', '' ) ),
        ),
        array(
            'title' => esc_html__('Logo', 'softing'),
            'subtitle' => esc_html__('Upload your Logo. If left blank theme will use site default logo.', 'softing'),
            'id' => 'img_logo',
            'type' => 'media',
            'url' => true,
            'customizer'=> true,
            'required' => array( 'logo_type', '=', 'img' ),
        ),
        array(
            'title' => esc_html__('Second logo for transparent menu', 'softing'),
            'subtitle' => esc_html__('if you use transparent menu you can use this second logo.', 'softing'),
            'id' => 'img_slogo',
            'type' => 'media',
            'url' => true,
            'customizer'=> true,
            'required' => array( 'logo_type', '=', 'img' ),
        ),
        array(
            'title' => esc_html__( 'Logo margin', 'softing' ),
            'id' => 'img_logo_m',
            'type' => 'spacing',
            'mode' => 'padding',
            'all' => false,
            'units' => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
            'output' => array( '#home .navbar-brand .logo-display' ),
            'default' => array(
                'margin-top' => '',
                'margin-right' => '',
                'margin-bottom' => '',
                'margin-left' => ''
            )
        ),
        array(
            'title' => esc_html__( 'Logo dimensions', 'softing' ),
            'desc' => esc_html__( 'Change logo dimensions', 'softing' ),
            'id' => 'img_logo_d',
            'type' => 'dimensions',
            'output' => array( '#home .navbar-brand .logo-display' ),
            'required' => array( 'logo_type', '=', 'img' ),
        ),
        array(
            'title' => esc_html__( 'Scrolled logo margin', 'softing' ),
            'id' => 'img_logo_sm',
            'type' => 'spacing',
            'mode' => 'padding',
            'all' => false,
            'units' => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
            'output' => array( '#home .navbar-brand .logo-scrolled' ),
            'default' => array(
                'margin-top' => '',
                'margin-right' => '',
                'margin-bottom' => '',
                'margin-left' => ''
            )
        ),
        array(
            'title' => esc_html__( 'Scrolled logo dimensions', 'softing' ),
            'desc' => esc_html__( 'Change logo dimensions', 'softing' ),
            'id' => 'img_logo_sd',
            'type' => 'dimensions',
            'output' => array( '#home .navbar-brand .logo-scrolled' ),
            'required' => array( 'logo_type', '=', 'img' ),
        ),
    )
));
/*************************************************
## SIDEBARS SECTION
*************************************************/
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Sidebars', 'softing' ),
    'id' => 'sidebarssection',
    'customizer_width' => '400px',
    'icon' => 'el el-website',
));
// SIDEBAR LAYOUT SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Sidebars Layout', 'softing' ),
    'desc' => esc_html__( 'You can change the below default layout type.', 'softing' ),
    'id' => 'sidebarslayoutsection',
    'subsection' => true,

    'icon' => 'el el-cogs',
    'fields' => array(
        array(
            'title' => esc_html__( 'Blog Page Layout', 'softing' ),
            'subtitle' => esc_html__( 'Choose the blog index page layout.', 'softing' ),
            'id' => 'index_layout',
            'type' => 'image_select',
            'options' => array(
                'left-sidebar' => array(
                    'alt' => 'Left Sidebar',
                    'img' => SOFTING_OPTIONS_PATH. '/img/2cl.png'
                ),
                'full-width' => array(
                    'alt' => 'Full Width',
                    'img' => SOFTING_OPTIONS_PATH. '/img/1col.png'
                ),
                'right-sidebar' => array(
                    'alt' => 'Right Sidebar',
                    'img' => SOFTING_OPTIONS_PATH . '/img/2cr.png'
                ),
            ),
            'default' => 'right-sidebar'
        ),
        array(
            'title' => esc_html__( 'Single Page Layout', 'softing' ),
            'subtitle' => esc_html__( 'Choose the single post page layout.', 'softing' ),
            'id' => 'single_layout',
            'type' => 'image_select',
            'options' => array(
                'left-sidebar' => array(
                    'alt' => 'Left Sidebar',
                    'img' => SOFTING_OPTIONS_PATH. '/img/2cl.png'
                ),
                'full-width' => array(
                    'alt' => 'Full Width',
                    'img' => SOFTING_OPTIONS_PATH. '/img/1col.png'
                ),
                'right-sidebar' => array(
                    'alt' => 'Right Sidebar',
                    'img' => SOFTING_OPTIONS_PATH . '/img/2cr.png'
                ),
            ),
            'default' => 'right-sidebar'
        ),
        array(
            'title' => esc_html__( 'Search Page Layout', 'softing' ),
            'subtitle' => esc_html__( 'Choose the search page layout.', 'softing' ),
            'id' => 'search_layout',
            'type' => 'image_select',
            'options' => array(
                'left-sidebar' => array(
                    'alt' => 'Left Sidebar',
                    'img' => SOFTING_OPTIONS_PATH. '/img/2cl.png'
                ),
                'full-width' => array(
                    'alt' => 'Full Width',
                    'img' => SOFTING_OPTIONS_PATH. '/img/1col.png'
                ),
                'right-sidebar' => array(
                    'alt' => 'Right Sidebar',
                    'img' => SOFTING_OPTIONS_PATH . '/img/2cr.png'
                ),
            ),
            'default' => 'full-width'
        ),
        array(
            'title' => esc_html__( 'Archive Page Layout', 'softing' ),
            'subtitle' => esc_html__( 'Choose the archive page layout.', 'softing' ),
            'id' => 'archive_layout',
            'type' => 'image_select',
            'options' => array(
                'left-sidebar' => array(
                    'alt' => 'Left Sidebar',
                    'img' => SOFTING_OPTIONS_PATH. '/img/2cl.png'
                ),
                'full-width' => array(
                    'alt' => 'Full Width',
                    'img' => SOFTING_OPTIONS_PATH. '/img/1col.png'
                ),
                'right-sidebar' => array(
                    'alt' => 'Right Sidebar',
                    'img' => SOFTING_OPTIONS_PATH . '/img/2cr.png'
                ),
            ),
            'default' => 'full-width'
        ),
        array(
            'title' => esc_html__( '404 Page Layout', 'softing' ),
            'subtitle' => esc_html__( 'Choose the 404 page layout.', 'softing' ),
            'id' => 'error_layout',
            'type' => 'image_select',
            'options' => array(
                'left-sidebar' => array(
                    'alt' => 'Left Sidebar',
                    'img' => SOFTING_OPTIONS_PATH. '/img/2cl.png'
                ),
                'full-width' => array(
                    'alt' => 'Full Width',
                    'img' => SOFTING_OPTIONS_PATH. '/img/1col.png'
                ),
                'right-sidebar' => array(
                    'alt' => 'Right Sidebar',
                    'img' => SOFTING_OPTIONS_PATH . '/img/2cr.png'
                ),
            ),
            'default' => 'full-width'
        ),
    )
));
// SIDEBAR COLORS SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Sidebar Customize', 'softing' ),
    'desc' => esc_html__( 'These are main settings for general theme!', 'softing' ),
    'id' => 'sidebarsgenaralsection',
    'subsection' => true,

    'icon' => 'el el-brush',
    'fields' => array(
        array(
            'title' => esc_html__( 'Sidebar Background', 'softing' ),
            'id' => 'sdbr_bg',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.nt-sidebar' ),
        ),
        array(
            'id' => 'sdbr_brd',
            'type' => 'border',
            'title' => esc_html__( 'Sidebar Border', 'softing' ),
            'output' => array( '.nt-sidebar' ),
            'all' => false,
        ),
        array(
            'title' => esc_html__( 'Sidebar Padding', 'softing' ),
            'id' => 'sdbr_pad',
            'type' => 'spacing',
            'mode' => 'padding',
            'all' => false,
            'units' => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
            'output' => array( '.nt-sidebar' ),
            'default' => array(
                'margin-top' => '',
                'margin-right' => '',
                'margin-bottom' => '',
                'margin-left' => ''
            )
        ),
        array(
            'title' => esc_html__( 'Sidebar Margin', 'softing' ),
            'id' => 'sdbr_mar',
            'type' => 'spacing',
            'mode' => 'margin',
            'all' => false,
            'units' => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
            'output' => array( '.nt-sidebar' ),
            'default' => array(
                'margin-top' => '',
                'margin-right' => '',
                'margin-bottom' => '',
                'margin-left' => ''
            )
        ),
    )
));
// SIDEBAR WIDGET COLORS SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Widget Customize', 'softing' ),
    'desc' => esc_html__( 'These are main settings for general theme!', 'softing' ),
    'id' => 'sidebarwidgetsection',
    'subsection' => true,

    'icon' => 'el el-brush',
    'fields' => array(
        array(
            'title' => esc_html__( 'Sidebar Widgets Background Color', 'softing' ),
            'id' => 'sdbr_w_bg',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.nt-sidebar .sidebar-widget' ),
        ),
        array(
            'title' => esc_html__( 'Widgets Border', 'softing' ),
            'id' => 'sdbr_w_brd',
            'type' => 'border',
            'output' => array( '.nt-sidebar .sidebar-widget' ),
            'all' => false,
        ),
        array(
            'title' => esc_html__( 'Widget Title Color', 'softing' ),
            'desc' => esc_html__( 'Set your own colors for the widgets.', 'softing' ),
            'id' => 'sdbr_wt',
            'type' => 'color',
            'output' => array( '.nt-sidebar .sidebar-widget h4' ),
        ),
        array(
            'title' => esc_html__( 'Widget Title Before Color', 'softing' ),
            'desc' => esc_html__( 'Set your own colors for the widgets.', 'softing' ),
            'id' => 'sdbr_wtbfr',
            'type' => 'background',
            'output' => array( '.nt-sidebar .sidebar-widget .widget-title::before' ),
        ),
        array(
            'title' => esc_html__( 'Widget Text Color', 'softing' ),
            'desc' => esc_html__( 'Set your own colors for the widgets.', 'softing' ),
            'id' => 'sdbr_wp',
            'type' => 'color',
            'output' => array( '.nt-sidebar .sidebar-widget' ),
        ),
        array(
            'title' => esc_html__( 'Widget Link Color', 'softing' ),
            'desc' => esc_html__( 'Set your own colors for the widgets.', 'softing' ),
            'id' => 'sdbr_a',
            'type' => 'color',
            'output' => array( '.nt-sidebar .sidebar-widget a' ),
        ),
        array(
            'title' => esc_html__( 'Widget Hover Link Color', 'softing' ),
            'desc' => esc_html__( 'Set your own hover colors for the widgets.', 'softing' ),
            'id' => 'sdbr_hvr_a',
            'type' => 'color',
            'output' => array( '.nt-sidebar .sidebar-widget a:hover' ),
        ),
        array(
            'title' => esc_html__( 'Widget Padding', 'softing' ),
            'id' => 'sdbr_w_pad',
            'type' => 'spacing',
            'mode' => 'padding',
            'all' => false,
            'units' => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
            'output' => array( '.nt-sidebar .sidebar-widget' ),
            'default' => array(
                'margin-top' => '',
                'margin-right' => '',
                'margin-bottom' => '',
                'margin-left' => ''
            )
        ),
        array(
            'title' => esc_html__( 'Widget Margin', 'softing' ),
            'id' => 'sdbr_w_mar',
            'type' => 'spacing',
            'mode' => 'margin',
            'all' => false,
            'units' => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
            'output' => array( '.nt-sidebar .sidebar-widget' ),
            'default' => array(
                'margin-top' => '',
                'margin-right' => '',
                'margin-bottom' => '',
                'margin-left' => ''
            )
        ),
    )
));
/*************************************************
## BLOG PAGE SECTION
*************************************************/
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Blog Page', 'softing' ),
    'id' => 'blogsection',
    'icon' => 'el el-home',
));
// BLOG HERO SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Blog Hero', 'softing' ),
    'desc' => esc_html__( 'These are blog index page hero text settings!', 'softing' ),
    'id' => 'blogherosubsection',
    'subsection'=> true,
    'icon' => 'el el-brush',
    'fields' => array(
        array(
            'title' => esc_html__( 'Blog Hero Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site blog index page hero section with switch option.', 'softing' ),
            'id' => 'blog_hero',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Blog Hero Alignment', 'softing' ),
            'subtitle' => esc_html__( 'Select blog page hero text alignment.', 'softing' ),
            'id' => 'blog_hero_alignment',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                '' => esc_html__( 'Select alignment', 'softing' ),
                'text-right' => esc_html__( 'right', 'softing' ),
                'text-center' => esc_html__( 'center', 'softing' ),
                'text-left' => esc_html__( 'left', 'softing' ),
            ),
            'default' => 'text-center',
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Hero Background', 'softing' ),
            'id' => 'blog_hero_bg',
            'type' => 'background',
            'preview' => true,
            'preview_media' => true,
            'default' => array(
                'background-position' => '50% 0px',
            ),
            'output' => array( '#nt-hero.blog-hero' ),
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Hero Overlay Type', 'softing' ),
            'subtitle' => esc_html__( 'Select blog page hero text alignment.', 'softing' ),
            'id' => 'blog_hero_overlay_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'dark' => esc_html__( 'Dark', 'softing' ),
                'custom' => esc_html__( 'Custom color', 'softing' ),
            ),
            'default' => 'dark',
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Hero Overlay Color', 'softing' ),
            'id' => 'blog_hero_overlay',
            'type' => 'color_rgba',
            'mode' => 'background',
            'default' => array(
                'color' => '',
                'alpha' => 0.5
            ),
            'output' => array( '#nt-hero.blog-hero.hero-overlay:before' ),
            'required' => array( array( 'blog_hero', '=', '1' ),array( 'blog_hero_overlay_type', '=', 'custom' ) ),
        ),
        array(
            'title' => esc_html__( 'Blog Hero Padding Top (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the hero section of the blog page.', 'softing' ),
            'id' => 'blog_hero_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Hero Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the hero section of the blog page.', 'softing' ),
            'id' => 'blog_hero_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Title', 'softing' ),
            'subtitle' => esc_html__( 'Add your blog index page title here.', 'softing' ),
            'id' => 'blog_title',
            'type' => 'text',
            'default' => 'BLOG.',
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Title Typography', 'softing' ),
            'id' => 'blog_title_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-blog .hero-title' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Slogan', 'softing' ),
            'subtitle' => esc_html__( 'Add your blog index page slogan here.', 'softing' ),
            'id' => 'blog_slogan',
            'type' => 'textarea',
            'default' => 'Read the latest articles.',
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Slogan Typography', 'softing' ),
            'id' => 'blog_slogan_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-blog .hero-subtitle' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Description', 'softing' ),
            'subtitle' => esc_html__( 'Add your blog index page description here.', 'softing' ),
            'id' => 'blog_desc',
            'type' => 'textarea',
            'default' => '',
            'required' => array( 'blog_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Description Typography', 'softing' ),
            'id' => 'blog_desc_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-blog .hero-desc' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'blog_hero', '=', '1' ),
        ),
    )
));
// BLOG LAYOUT AND POST COLUMN STYLE
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Blog Content', 'softing' ),
    'id' => 'blogcontentsubsection',
    'subsection' => true,
    'icon' => 'el el-brush',
    'fields' => array(
        array(
            'title' => esc_html__( 'Blog Content Padding Top (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the content of the blog page.', 'softing' ),
            'id' => 'blog_cont_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
        array(
            'title' => esc_html__( 'Blog Content Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the content of the blog page.', 'softing' ),
            'id' => 'blog_cont_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
        array(
            'id' => 'post_categories',
            'type' => 'select',
            'title' => esc_html__( 'Show Posts by Specific Categories' , 'softing' ),
            'data' => 'categories',
            'args' => array(array('post_type' => array('post') ) ),
            'multi' => true,
            'placeholder' => esc_html__( 'enter category name here' , 'softing' ),
            'sortable' => true
        ),
        array(
            'title' => esc_html__( 'Post Image and Text Alignment', 'softing' ),
            'subtitle' => esc_html__( 'Select post content alignment.', 'softing' ),
            'id' => 'post_alignment',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                '' => esc_html__( 'Select alignment', 'softing' ),
                'text-right' => esc_html__( 'right', 'softing' ),
                'text-center' => esc_html__( 'center', 'softing' ),
                'text-left' => esc_html__( 'left', 'softing' ),
            ),
            'default' => 'text-left',
        ),
        array(
            'title' => esc_html__( 'Blog Post Title Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site blog index page post title with switch option.', 'softing' ),
            'id' => 'post_title',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Blog Post Meta Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site blog index page post meta with switch option.', 'softing' ),
            'id' => 'post_meta',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Blog Post Author Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site blog index page post author with switch option.', 'softing' ),
            'id' => 'post_author',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
            'required' => array( 'post_meta', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Post Date Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site blog index page post date with switch option.', 'softing' ),
            'id' => 'post_date',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
            'required' => array( 'post_meta', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Post Category Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site blog index page post category with switch option.', 'softing' ),
            'id' => 'post_category',
            'type' => 'switch',
            'default' => 0,
            'on' => 'On',
            'off' => 'Off',
            'required' => array( 'post_meta', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Blog Post Excerpt Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site blog index page post meta with switch option.', 'softing' ),
            'id' => 'post_excerpt',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Post Excerpt Size', 'softing' ),
            'subtitle' => esc_html__( 'You can control blog post excerpt size with this option.', 'softing' ),
            'id' => 'excerptsz',
            'type' => 'slider',
            'default' => 80,
            'min' => 0,
            'step' => 1,
            'max' => 500,
            'display_value' => 'text',
            'required' => array( 'post_excerpt', '=', '1' ),
        ),
    )
));

/*************************************************
## SINGLE PAGE SECTION
*************************************************/
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Single Page', 'softing' ),
    'id' => 'singlesection',
    'icon' => 'el el-home-alt',
));
// SINGLE HERO SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Single Hero', 'softing' ),
    'desc' => esc_html__( 'These are single page hero section settings!', 'softing' ),
    'id' => 'singleherosubsection',
    'subsection'=> true,
    'icon' => 'el el-brush',
    'fields' => array(
        array(
            'title' => esc_html__( 'Single Hero display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page hero section with switch option.', 'softing' ),
            'id' => 'single_hero',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Single Hero Alignment', 'softing' ),
            'subtitle' => esc_html__( 'Select single page hero text alignment.', 'softing' ),
            'id' => 'single_hero_alignment',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                '' => esc_html__( 'Select alignment', 'softing' ),
                'text-right' => esc_html__( 'right', 'softing' ),
                'text-center' => esc_html__( 'center', 'softing' ),
                'text-left' => esc_html__( 'left', 'softing' ),
            ),
            'default' => 'text-center',
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Hero Background', 'softing' ),
            'id' => 'single_hero_bg',
            'type' => 'background',
            'output' => array( '#nt-single #nt-hero' ),
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Hero Overlay Type', 'softing' ),
            'subtitle' => esc_html__( 'Select single page hero background image overlay type.', 'softing' ),
            'id' => 'single_hero_overlay_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'dark' => esc_html__( 'Dark', 'softing' ),
                'custom' => esc_html__( 'Custom color', 'softing' ),
            ),
            'default' => 'dark',
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Hero Overlay Color', 'softing' ),
            'id' => 'single_hero_overlay',
            'type' => 'color_rgba',
            'mode' => 'background',
            'default' => array(
                'alpha' => 0.5
            ),
            'output' => array( '#nt-hero.single-hero.hero-overlay:before' ),
            'required' => array( array( 'single_hero', '=', '1' ),array( 'single_hero_overlay_type', '=', 'custom' ) ),
        ),
        array(
            'title' => esc_html__( 'Single Hero Padding Top (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the hero section of the single page.', 'softing' ),
            'id' => 'single_hero_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Hero Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the hero section of the single page.', 'softing' ),
            'id' => 'single_hero_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Title Typography', 'softing' ),
            'id' => 'single_title_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-single  .hero-title' ),
            'units' => 'px',
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Slogan', 'softing' ),
            'subtitle' => esc_html__( 'Add your single page slogan here.', 'softing' ),
            'id' => 'single_slogan',
            'type' => 'textarea',
            'default' => '',
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Slogan Typography', 'softing' ),
            'id' => 'single_slogan_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-single  .hero-subtitle' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Description', 'softing' ),
            'subtitle' => esc_html__( 'Add your single page description here.', 'softing' ),
            'id' => 'single_desc',
            'type' => 'textarea',
            'default' => '',
            'required' => array( 'single_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Description Typography', 'softing' ),
            'id' => 'single_desc_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-single  .hero-desc' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'single_hero', '=', '1' ),
        ),

    )
));
// SINGLE CONTENT SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Single Content', 'softing' ),
    'id' => 'singlecontentsubsection',
    'subsection' => true,

    'icon' => 'el el-brush',
    'fields' => array(
        array(
            'title' => esc_html__( 'Single Content Padding Top (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the content of the single page.', 'softing' ),
            'id' => 'single_cont_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
        array(
            'title' => esc_html__( 'Single Content Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the content of the single page.', 'softing' ),
            'id' => 'single_cont_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
        array(
            'title' => esc_html__( 'Single Post All Meta Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page post all meta with switch option.', 'softing' ),
            'id' => 'single_post_meta_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Single Post Category Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page post meta category with switch option.', 'softing' ),
            'id' => 'single_post_cats_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
            'required' => array( 'single_post_meta_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Post Author Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page post meta author with switch option.', 'softing' ),
            'id' => 'single_post_author_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
            'required' => array( 'single_post_meta_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Post Date Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page post meta date with switch option.', 'softing' ),
            'id' => 'single_post_date_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
            'required' => array( 'single_post_meta_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Post Tags Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page post meta tags with switch option.', 'softing' ),
            'id' => 'single_post_tags_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
            'required' => array( 'single_post_meta_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Post Authorbox', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page post authorbox with switch option.', 'softing' ),
            'id' => 'post_authorbox_onoff',
            'type' => 'switch',
            'default' => 0,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Single Post Pagination Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page post next and prev pagination with switch option.', 'softing' ),
            'id' => 'single_navigation_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Single Related Post Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page related post with switch option.', 'softing' ),
            'id' => 'single_related_onoff',
            'type' => 'switch',
            'default' => 0,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Single Related Post Count', 'softing' ),
            'subtitle' => esc_html__( 'You can control related post count with this option.', 'softing' ),
            'id' => 'related_perpage',
            'type' => 'slider',
            'default' => 3,
            'min' => 1,
            'step' => 1,
            'max' => 24,
            'display_value' => 'text',
            'required' => array( 'single_related_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Related Post Title', 'softing' ),
            'subtitle' => esc_html__( 'Add your single page related post section title here.', 'softing' ),
            'id' => 'related_title',
            'type' => 'text',
            'default' => 'You May Also Like',
            'required' => array( 'single_related_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Single Comment Form Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site single page post comment form with switch option.', 'softing' ),
            'id' => 'single_comment_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
    )
));

//ARCHIVE PAGE SECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Archive Page', 'softing' ),
    'desc' => esc_html__( 'These are archive page settings!', 'softing' ),
    'id' => 'archivesection',
    'icon' => 'el el-folder-open',
    'fields'=> array(
        array(
            'title' => esc_html__( 'Archive Hero display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site archive page hero section with switch option.', 'softing' ),
            'id' => 'archive_hero',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Archive Hero Alignment', 'softing' ),
            'subtitle' => esc_html__( 'Select archive page hero text alignment.', 'softing' ),
            'id' => 'archive_hero_alignment',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                '' => esc_html__( 'Select alignment', 'softing' ),
                'text-right' => esc_html__( 'right', 'softing' ),
                'text-center' => esc_html__( 'center', 'softing' ),
                'text-left' => esc_html__( 'left', 'softing' ),
            ),
            'default' => 'text-center',
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Hero Background', 'softing' ),
            'id' => 'archive_hero_bg',
            'type' => 'background',
            'output' => array( '#nt-archive #nt-hero' ),
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Hero Overlay Type', 'softing' ),
            'subtitle' => esc_html__( 'Select archive page hero background image overlay type.', 'softing' ),
            'id' => 'archive_hero_overlay_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'dark' => esc_html__( 'Dark', 'softing' ),
                'custom' => esc_html__( 'Custom color', 'softing' ),
            ),
            'default' => 'dark',
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Hero Overlay Color', 'softing' ),
            'id' => 'archive_hero_overlay',
            'type' => 'color_rgba',
            'mode' => 'background',
            'default' => array(
                'alpha' => 0.5
            ),
            'output' => array( '#nt-hero.archive-hero.hero-overlay:before' ),
            'required' => array( array( 'archive_hero', '=', '1' ),array( 'archive_hero_overlay_type', '=', 'custom' ) ),
        ),
        array(
            'title' => esc_html__( 'Archive Hero Padding Top', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the hero section of the archive page.', 'softing' ),
            'id' => 'archive_hero_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Hero Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the hero section of the archive page.', 'softing' ),
            'id' => 'archive_hero_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Custom Archive Title', 'softing' ),
            'subtitle' => esc_html__( 'Add your custom archive page title here.', 'softing' ),
            'id' => 'archive_title',
            'type' => 'text',
            'default' => 'ARCHIVE.',
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Title Typography', 'softing' ),
            'id' => 'archive_title_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-archive  .hero-title' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Slogan', 'softing' ),
            'subtitle' => esc_html__( 'Add your archive page slogan here.', 'softing' ),
            'id' => 'archive_slogan',
            'type' => 'textarea',
            'default' => '',
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Slogan Typography', 'softing' ),
            'id' => 'archive_slogan_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-archive  .hero-subtitle' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Description', 'softing' ),
            'subtitle' => esc_html__( 'Add your archive page description here.', 'softing' ),
            'id' => 'archive_desc',
            'type' => 'textarea',
            'default' => '',
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Description Typography', 'softing' ),
            'id' => 'archive_desc_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-archive  .hero-desc' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'archive_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Archive Content Padding Top (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the content of the Archive page.', 'softing' ),
            'id' => 'archive_cont_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
        array(
            'title' => esc_html__( 'Archive Content Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the content of the Archive page.', 'softing' ),
            'id' => 'archive_cont_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
    )
));

//404 PAGE SECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( '404 Page', 'softing' ),
    'id' => 'errorsection',
    'desc' => esc_html__( 'These are main settings for general theme!', 'softing' ),
    'icon' => 'el el-error',
    'fields' => array(
        array(
            'title' => esc_html__( '404 Hero display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site 404 page hero section with switch option.', 'softing' ),
            'id' => 'error_hero',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( '404 Hero Alignment', 'softing' ),
            'subtitle' => esc_html__( 'Select 404 page hero text alignment.', 'softing' ),
            'id' => 'error_hero_alignment',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                '' => esc_html__( 'Select alignment', 'softing' ),
                'text-right' => esc_html__( 'right', 'softing' ),
                'text-center' => esc_html__( 'center', 'softing' ),
                'text-left' => esc_html__( 'left', 'softing' ),
            ),
            'default' => 'text-center',
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Hero Background', 'softing' ),
            'id' => 'error_hero_bg',
            'type' => 'background',
            'output' => array( '#nt-404 #nt-hero' ),
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Hero Overlay Type', 'softing' ),
            'subtitle' => esc_html__( 'Select error page hero background image overlay type.', 'softing' ),
            'id' => 'error_hero_overlay_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'dark' => esc_html__( 'Dark', 'softing' ),
                'custom' => esc_html__( 'Custom color', 'softing' ),
            ),
            'default' => 'dark',
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Hero Overlay Color', 'softing' ),
            'id' => 'error_hero_overlay',
            'type' => 'color_rgba',
            'mode' => 'background',
            'default' => array(
                'alpha' => 0.5
            ),
            'output' => array( '#nt-hero.error-hero.hero-overlay:before' ),
            'required' => array( array( 'error_hero', '=', '1' ),array( 'error_hero_overlay_type', '=', 'custom' ) ),
        ),
        array(
            'title' => esc_html__( '404 Hero Padding Top', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the hero section of the error page.', 'softing' ),
            'id' => 'error_hero_padt',
            'type' => 'slider',
            'default' => 150,
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Hero Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the hero section of the error page.', 'softing' ),
            'id' => 'error_hero_padb',
            'type' => 'slider',
            'default' => 10,
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Title', 'softing' ),
            'subtitle' => esc_html__( 'Add your 404 page title here.', 'softing' ),
            'id' => 'error_title',
            'type' => 'text',
            'default' => '404 - Not Found',
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Title Typography', 'softing' ),
            'id' => 'error_title_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-404  .hero-title' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Slogan', 'softing' ),
            'subtitle' => esc_html__( 'Add your 404 page slogan here.', 'softing' ),
            'id' => 'error_slogan',
            'type' => 'textarea',
            'default' => 'OOPS! THAT PAGE CAN NOT BE FOUND',
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Slogan Typography', 'softing' ),
            'id' => 'error_slogan_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-404  .hero-subtitle' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Description', 'softing' ),
            'subtitle' => esc_html__( 'Add your 404 page description here.', 'softing' ),
            'id' => 'error_desc',
            'type' => 'textarea',
            'default' => '',
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Description Typography', 'softing' ),
            'id' => 'error_desc_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-404  .hero-desc' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'error_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( '404 Content Padding Top (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the content of the error page.', 'softing' ),
            'id' => 'error_cont_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
        array(
            'title' => esc_html__( '404 Content Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the content of the 404 page.', 'softing' ),
            'id' => 'error_cont_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
    )
));
//SEARCH PAGE SECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Search Page', 'softing' ),
    'id' => 'searchsection',
    'desc' => esc_html__( 'These are main settings for general theme!', 'softing' ),
    'icon' => 'el el-search',
    'fields' => array(
        array(
            'title' => esc_html__( 'Search Hero display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site search page hero section with switch option.', 'softing' ),
            'id' => 'search_hero',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Search Hero Alignment', 'softing' ),
            'subtitle' => esc_html__( 'Select search page hero text alignment.', 'softing' ),
            'id' => 'search_hero_alignment',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                '' => esc_html__( 'Select alignment', 'softing' ),
                'text-right' => esc_html__( 'right', 'softing' ),
                'text-center' => esc_html__( 'center', 'softing' ),
                'text-left' => esc_html__( 'left', 'softing' ),
            ),
            'default' => 'text-center',
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Hero Background', 'softing' ),
            'id' => 'search_hero_bg',
            'type' => 'background',
            'output' => array( '#nt-search #nt-hero' ),
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Hero Overlay Type', 'softing' ),
            'subtitle' => esc_html__( 'Select search page hero background image overlay type.', 'softing' ),
            'id' => 'search_hero_overlay_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'dark' => esc_html__( 'Dark', 'softing' ),
                'custom' => esc_html__( 'Custom color', 'softing' ),
            ),
            'default' => 'dark',
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Hero Overlay Color', 'softing' ),
            'id' => 'search_hero_overlay',
            'type' => 'color_rgba',
            'mode' => 'background',
            'default' => array(
                'alpha' => 0.5
            ),
            'output' => array( '#nt-hero.search-hero.hero-overlay:before' ),
            'required' => array( array( 'search_hero', '=', '1' ),array( 'search_hero_overlay_type', '=', 'custom' ) ),
        ),
        array(
            'title' => esc_html__( 'Search Hero Padding Top', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the hero section of the search page.', 'softing' ),
            'id' => 'search_hero_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Hero Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the hero section of the search page.', 'softing' ),
            'id' => 'search_hero_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Title', 'softing' ),
            'subtitle' => esc_html__( 'Add your search page title here.', 'softing' ),
            'id' => 'search_title',
            'type' => 'text',
            'default' => 'Search Results for :',
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Title Typography', 'softing' ),
            'id' => 'search_title_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-search  .hero-title' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Slogan', 'softing' ),
            'subtitle' => esc_html__( 'Add your search page slogan here.', 'softing' ),
            'id' => 'search_slogan',
            'type' => 'textarea',
            'default' => '',
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Slogan Typography', 'softing' ),
            'id' => 'search_slogan_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-search  .hero-subtitle' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Description', 'softing' ),
            'subtitle' => esc_html__( 'Add your search page description here.', 'softing' ),
            'id' => 'search_desc',
            'type' => 'textarea',
            'default' => '',
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Description Typography', 'softing' ),
            'id' => 'search_desc_typo',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing'=> true,
            'all_styles' => true,
            'output' => array( '#nt-search  .hero-desc' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            ),
            'required' => array( 'search_hero', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Search Content Padding Top (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the content of the search page.', 'softing' ),
            'id' => 'search_cont_padt',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
        array(
            'title' => esc_html__( 'Search Content Padding Bottom (px)', 'softing' ),
            'subtitle' => esc_html__( 'You can set the bottom spacing of the content of the search page.', 'softing' ),
            'id' => 'search_cont_padb',
            'type' => 'slider',
            'default' => '',
            'min' => 0,
            'step' => 1,
            'max' => 1000,
            'display_value' => 'text',
        ),
    )
));
//FOOTER SECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Footer', 'softing' ),
    'desc' => esc_html__( 'These are main settings for general theme!', 'softing' ),
    'id' => 'footersection',

    'icon' => 'el el-photo',
    'fields' => array(
        array(
            'title' => esc_html__( 'Footer Section Display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the site footer section on the site with switch option.', 'softing' ),
            'id' => 'footer_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        array(
            'title' => esc_html__( 'Footer Type', 'softing' ),
            'subtitle' => esc_html__( 'Select your footer type.', 'softing' ),
            'id' => 'footer_type',
            'type' => 'select',
            'customizer'=> true,
            'options' => array(
                'default' => 'Deafult Site Footer',
                'custom' => 'Custom Footer',
                'page' => 'Page Content',
            ),
            'default' => 'default',
            'required' => array( 'footer_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__('Select Page', 'softing'),
            'subtitle' => esc_html__('Select your page for footer.', 'softing'),
            'id' => 'footer_custom_page',
            'type' => 'select',
            'multi' => false,
            'data' => 'page',
            'customizer' => true,
            'required' => array(
                array( 'footer_onoff', '=', '1' ),
                array( 'footer_type', '=', 'page' )
            ),
        ),
        array(
            'title' => esc_html__( 'Create your custom footer', 'softing' ),
            'subtitle' => esc_html__( 'HTML allowed (wp_kses)', 'softing' ),
            'id' => 'custom_footer',
            'type' => 'editor',
            'validate' => 'html',
            'default' => 'Enter your custom footer here. Html can be entered in this field.',
            'required' => array(
                array( 'footer_onoff', '=', '1' ),
                array( 'footer_type', '=', 'custom' )
            ),
        ),
        array(
            'title' => esc_html__( 'Copyright Text', 'softing' ),
            'subtitle' => esc_html__( 'HTML allowed (wp_kses)', 'softing' ),
            'desc' => esc_html__( 'Enter your site copyright here.', 'softing' ),
            'id' => 'footer_copyright',
            'type' => 'editor',
            'default' => '<p><i class="fa fa-copyright"></i> Copyright 2019. All Rights Reserved by <a href="#">Ninetheme</a></p>',
            'required' => array(
                array( 'footer_onoff', '=', '1' ),
                array( 'footer_type', '=', 'default' )
            ),
        ),
        array(
            'title' => esc_html__( 'Copyright Text Color', 'softing' ),
            'desc' => esc_html__( 'Set your own colors for the copyright.', 'softing' ),
            'id' => 'footer_copy_clr',
            'type' => 'color',
            'transparent'=> false,
            'output' => array( '.nt-footer .nt-copyright, .nt-footer .nt-copyright p' ),
            'required' => array(
                array( 'footer_onoff', '=', '1' ),
                array( 'footer_type', '=', 'default' )
            ),
        ),
        array(
            'title' => esc_html__( 'Footer Padding', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the site main footer.', 'softing' ),
            'id' => 'footer_pad',
            'type' => 'spacing',
            'output' => array('.nt-footer.footer-bottom'),
            'mode' => 'padding',
            'units' => array('em', 'px'),
            'units_extended' => 'false',
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            ),
            'required' => array(
                array( 'footer_onoff', '=', '1' ),
                array( 'footer_type', '=', 'default' )
            ),
        ),
        //information on-off
        array(
            'id' =>'info_f0',
            'type' => 'info',
            'style' => 'success',
            'title' => esc_html__('Success!', 'softing'),
            'icon' => 'el el-info-circle',
            'customizer'=> false,
            'desc' => sprintf(esc_html__('%s section is disabled on the site.', 'softing'),'<b>Site Main Footer</b>'),
            'required' => array( 'footer_onoff', '=', '0' ),
        ),
    )
));
//FOOTER WIDGETIZE SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Footer Widget Area', 'softing' ),
    'id' => 'footerwidgetizesection',
    'icon' => 'el el-th-large',
    'fields' => array(
        array(
            'title' => esc_html__( 'Footer widget area section display', 'softing' ),
            'subtitle' => esc_html__( 'You can enable or disable the footer widget area with one option.', 'softing' ),
            'id' => 'footer_widgetize_onoff',
            'type' => 'switch',
            'default' => 1,
            'on' => 'On',
            'off' => 'Off',
        ),
        //information on-off
        array(
            'id' =>'info_fw0',
            'type' => 'info',
            'style' => 'success',
            'title' => esc_html__('Success!', 'softing'),
            'icon' => 'el el-info-circle',
            'customizer'=> false,
            'desc' => sprintf(esc_html__('%s section is disabled on the site. Please activate to view subsection options.', 'softing'),'<b>Footer Widget Area</b>'),
            'required' => array( 'footer_widgetize_onoff', '=', '0' ),
        ),
    )
));
//WIDGET SETTINGS SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Widget Settings', 'softing' ),
    'id' => 'widgetsettingssection',
    'subsection' => true,
    'icon' => 'el el-cogs',
    'fields' => array(
        array(
            'title' => esc_html__( 'Default footer widgets display', 'softing' ),
            'desc' => esc_html__( 'This option disable or enable theme default widgets from widgets', 'softing' ),
            'id' => 'default_widgets',
            'type' => 'switch',
            'default' => 1,
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__('Create Custom Widgets', 'softing'),
            'subtitle' => esc_html__('Enter your custom column number for custom widget', 'softing'),
            'desc' => esc_html__('This option creates a new widget based on your custom column.', 'softing'),
            'id' => 'custom_widgets',
            'type' => 'multi_text',
            'customizer'=> true,
            'validate' => 'numeric',
            'add_text' => esc_html__('Add Column', 'softing'),
            'default' => array(3,3,3,3),
            'show_empty'=> true,
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),
        ),
        //information on-off
        array(
            'id' =>'info_fw1',
            'type' => 'info',
            'style' => 'success',
            'title' => esc_html__('Information!', 'softing'),
            'icon' => 'el el-info-circle',
            'customizer'=> false,
            'desc' => sprintf(esc_html__('This section options are disabled by the %s Section. Please activate to view options.', 'softing'),'<b>Footer Widget Area</b>'),
            'required' => array( 'footer_widgetize_onoff', '=', '0' ),
        ),
    )
));
//FOOTER WIDGETIZE COLOR SUBSECTION
Redux::setSection( $softing_pre,array(
    'title' => esc_html__( 'Widget Area Customize', 'softing' ),
    'id' => 'widgetcustomizesection',
    'subsection' => true,
    'customizer_width' => '400px',
    'icon' => 'el el-brush',
    'fields' => array(
        array(
            'title' => esc_html__( 'Footer Widget Area Background', 'softing' ),
            'id' => 'fw_bg',
            'type' => 'background',
            'output' => array( '.nt-footer-sidebar' ),
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Background Image Overlay', 'softing' ),
            'desc' => esc_html__( 'This option usefull when the widget area has background image.', 'softing' ),
            'id' => 'fw_overlay',
            'type' => 'color_rgba',
            'default' => false,
            'output' => array( '.nt-footer-sidebar:before' ),
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),

        ),
        array(
            'title' => esc_html__( 'Widget Title Colors', 'softing' ),
            'desc' => esc_html__( 'Set your own color for the widgets title.', 'softing' ),
            'id' => 'fw_w',
            'type' => 'color',
            'output' => array( '.nt-footer-sidebar h4' ),
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Widget Link Color', 'softing' ),
            'desc' => esc_html__( 'Set your own color for the widgets link.', 'softing' ),
            'id' => 'fw_wa',
            'type' => 'color',
            'output' => array( '.nt-footer-sidebar .footer-widget a' ),
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Widget Hover Link Color', 'softing' ),
            'desc' => esc_html__( 'Set your own hover colors for the widgets link.', 'softing' ),
            'id' => 'fw_wa',
            'type' => 'color',
            'output' => array( '.nt-footer-sidebar .footer-widget a' ),
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Widget Text Color', 'softing' ),
            'desc' => esc_html__( 'Set your own colors for the widgets.', 'softing' ),
            'id' => 'fw_wp',
            'type' => 'color',
            'output' => array( '.nt-footer-sidebar .footer-widget' ),
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),
        ),
        array(
            'title' => esc_html__( 'Widget Area Padding', 'softing' ),
            'subtitle' => esc_html__( 'You can set the top spacing of the widget area.', 'softing' ),
            'id' => 'fw_pad',
            'type' => 'spacing',
            'output' => array('.nt-footer-sidebar.footer-widget-area'),
            'mode' => 'padding',
            'units' => array('em', 'px'),
            'units_extended' => 'false',
            'default' => array(
                'padding-top' => '',
                'padding-right' => '',
                'padding-bottom' => '',
                'padding-left' => '',
                'units' => 'px',
            ),
            'required' => array( 'footer_widgetize_onoff', '=', '1' ),
        ),
        //information on-off
        array(
            'id' =>'info_fw2',
            'type' => 'info',
            'style' => 'success',
            'title' => esc_html__('Information!', 'softing'),
            'icon' => 'el el-info-circle',
            'customizer'=> false,
            'desc' => sprintf(esc_html__('This section options are disabled by the %s Section. Please activate to view options.', 'softing'),'<b>Footer Widget Area</b>'),
            'required' => array( 'footer_widgetize_onoff', '=', '0' ),
        ),
    )
));

Redux::setSection( $softing_pre,array(
    'id' => 'inportexport_settings',
    'title' => esc_html__( 'Import / Export', 'softing' ),
    'desc' => esc_html__( 'Import and Export your Theme Options from text or URL.', 'softing' ),
    'icon' => 'el el-hdd',
    'fields' => array(
        array(
            'id' => 'opt-import-export',
            'type' => 'import_export',
            'title' => '',
            'customizer' => false,
            'subtitle' => '',
            'full_width' => true,
        ),
    )
));
/*
* <--- END SECTIONS
*/

/** Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions. **/
if ( ! function_exists( 'change_arguments' ) ) {
    function change_arguments( $softing_options_args ) {
        return $softing_options_args;
    }
}
