<?php

if ( is_admin() )
return false;

/**
 * Custom template parts for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package softing
*/


/*************************************************
##  LOGO
*************************************************/

if ( ! function_exists( 'softing_logo' ) ) {
    function softing_logo() {

        // Redux prefix load
        global $softing;

        $default_logo = get_template_directory().'/images/logo.png';
        $logo_display = isset($softing['nav_logo_onoff']) ? $softing['nav_logo_onoff'] : '1';
        $logo_type = isset($softing['logo_type']) && !empty($softing['logo_type']) ? $softing['logo_type'] : 'img';


        // metabox image logo
        $mb_slogo = wp_get_attachment_url( get_post_meta(get_the_ID(), 'softing_page_logo_sticky', true ),'full' );
        $mb_logo = wp_get_attachment_url( get_post_meta(get_the_ID(), 'softing_page_logo', true ),'full' );
        $mb_logo_url = $mb_logo != '' ? $mb_logo : $default_logo;
        $logo_class = $mb_logo != '' ? 'img' : $logo_type;

        // logo
        if ( $logo_display != '0' ) { ?>

            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="nt-logo" class="<?php echo esc_attr( $logo_class ); ?>-logo standard-logo navbar-brand">

                <?php if ( $mb_logo == '' ) {

                    // image logo
                    if ( $logo_type == 'img' ) {

                        $logo_url = isset($softing['img_logo']) && !empty($softing['img_logo']['url']) ? $softing['img_logo']['url'] : $default_logo;

                        //sticky logo
                        $slogo_url = isset($softing['img_slogo']) && !empty($softing['img_slogo']['url']) ? $softing['img_slogo']['url'] : '';

                        if ( $slogo_url != '' ) { ?>
                            <!-- Image -->
                            <img src="<?php echo esc_url( $slogo_url ); ?>" alt="<?php bloginfo('name');?>" class="logo logo-display" />
                        <?php } ?>

                        <!-- sticky logo -->
                        <img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php bloginfo('name');?>" class="logo logo-scrolled" />

                        <?php

                        // sitename logo
                    } elseif ( $logo_type == 'sitename' ) {

                        echo esc_html( get_bloginfo('name') );

                        // custom text logo
                    } elseif ( $logo_type == 'customtext' ) {

                        $text_logo = isset($softing['text_logo']) && !empty($softing['text_logo']) ? $softing['text_logo'] : get_bloginfo('name');
                        echo esc_html( $text_logo );

                        // default image logo
                    } else { ?>

                        <!-- Image -->
                        <img src="<?php echo esc_url( $default_logo ); ?>" alt="<?php bloginfo('name');?>"  class="logo logo-scrolled"/>

                    <?php } ?>


                <?php } else {

                    if ( $mb_slogo != '' ) { ?>
                        <!-- Image -->
                        <img src="<?php echo esc_url( $mb_slogo ); ?>" alt="<?php bloginfo('name');?>" class="logo logo-display" />
                    <?php } ?>

                    <!-- sticky logo -->
                    <img src="<?php echo esc_url( $mb_logo_url ); ?>" alt="<?php bloginfo('name');?>" class="logo logo-scrolled" />

                <?php } ?>

            </a>
            <?php
        }
    }
}

if ( ! function_exists( 'softing_retina_logo' ) ) {
    function softing_retina_logo() {

        // Redux prefix load
        global $softing;

        $default_logo = get_theme_file_uri().'/images/logo-big@2x.png';
        $logo_display = isset($softing['nav_logo_onoff']) ? $softing['nav_logo_onoff'] : '1';
        $logo_type = isset($softing['logo_type']) && !empty($softing['logo_type']) ? $softing['logo_type'] : 'img';

        // metabox image logo
        $mb_logo2x = wp_get_attachment_url( get_post_meta(get_the_ID(), 'softing_page_logo2x', true ),'full' );
        $mb_logo2x_url = $mb_logo2x != '' ? $mb_logo2x : $default_logo;
        $logo_class = $mb_logo2x != '' ? 'img' : $logo_type;

        // logo
        if ( $logo_display != '0' ) { ?>

            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="nt-retina-logo" class="retina-logo navbar-brand">

                <?php
                if ( $mb_logo2x == '' ) {

                    // image logo
                    if ( $logo_type == 'img' ) {

                        $logo_url = isset($softing['img_logo2x']) && !empty($softing['img_logo2x']['url']) ? $softing['img_logo2x']['url'] : $default_logo;

                        ?>
                        <!-- Image -->
                        <img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php bloginfo('name');?>" />

                        <?php
                    }

                } else { ?>

                    <img src="<?php echo esc_url( $mb_logo2x_url ); ?>" alt="<?php bloginfo('name');?>" />

                <?php } ?>
            </a>
            <?php
        }
    }
}


/*************************************************
##  THEME NAVIGATION
*************************************************/

if ( ! function_exists( 'softing_header' ) ) {
    function softing_header() {

        // Redux prefix load
        global $softing;

        $nav = isset($softing[ 'nav_onoff' ]) ? $softing[ 'nav_onoff' ] : '1';
        $nav_type = isset($softing[ 'nav_bg_type' ]) ? $softing[ 'nav_bg_type' ] : 'normal';


        if ( is_page() ) {

            $p_nav = rwmb_meta( 'softing_page_nav_onoff' );
            $nav = $p_nav != '' ? $p_nav : $nav;

            $p_nav_type = rwmb_meta( 'softing_page_nav_bgtype' );
            $nav_type = $p_nav_type != '' ? $p_nav_type : $nav_type;
        }

        if ( $nav != '0' ) {
            ?>
            <!-- Header
            ============================================= -->
            <header id="home" class="nt-site-header">
                <!-- Start Navigation -->
                <?php if( $nav_type == 'normal' ){ ?>
                <nav class="navbar navbar-default navbar-sticky bootsnav on no-full has-background">
                <?php }elseif( $nav_type == 'fixed' ){ ?>
                <nav class="navbar navbar-default navbar-fixed fixed-style dark bootsnav on no-full no-background">
                <?php }elseif( $nav_type == 'trans' ){ ?>
                <nav class="navbar navbar-default navbar-fixed navbar-transparent transparent-style white bootsnav on no-full">
                <?php } ?>

                    <div class="container">

                        <!-- Start Atribute Navigation -->
                        <?php softing_header_button(); ?>
                        <!-- End Atribute Navigation -->

                        <!-- Start Header Navigation -->
                        <div class="navbar-header">

                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                                <i class="fa fa-bars"></i>
                            </button>

                            <?php softing_logo(); ?>

                        </div>
                        <!-- End Header Navigation -->

                        <!-- Collect the nav links, forms, and other content for toggling -->
                        <div class="collapse navbar-collapse" id="navbar-menu">
                            <ul class="nav navbar-nav navbar-right" data-in="#" data-out="#">

                                <?php
                                //default wp menu
                                wp_nav_menu(
                                    array(
                                        'menu'            => 'header_menu_1',
                                        'theme_location'  => 'header_menu_1',
                                        'container'       => '', // menu wrapper element
                                        'container_class' => '',
                                        'container_id'    => '',  // default: none
                                        'menu_class'      => '', // ul class
                                        'menu_id'         => '', // ul id
                                        'items_wrap'      => '%3$s',
                                        'before'          => '', // before <a>
                                        'after'           => '', // after <a>
                                        'link_before'     => '', // inside <a>, before text
                                        'link_after'      => '', // inside <a>, after text
                                        'depth'           => 3, // '0' to display all depths
                                        'echo'            => true,
                                        'fallback_cb'     => 'Softing_Wp_Bootstrap_Navwalker::fallback',
                                        'walker'          => new Softing_Wp_Bootstrap_Navwalker()
                                    )
                                );
                                ?>
                            </ul>
                        </div><!-- /.navbar-collapse -->
                    </div>
                </nav>
                <!-- End Navigation -->
            </header>
            <!-- End Header -->
            <?php
        }//end if nav
    }
}
add_action( 'softing_header_action',  'softing_header', 10 );

/*************************************************
##  TOP HEADER BUTTON RIGHT
*************************************************/

if ( ! function_exists( 'softing_header_button' ) ) {
    function softing_header_button() {

        global $softing;

        $nav_btn = isset($softing[ 'nav_btn_onoff' ]) ? $softing[ 'nav_btn_onoff' ] : '0';
        $p_nav_btn = rwmb_meta( 'softing_page_nav_btn' );
        $nav_btn = is_page() && $p_nav_btn != '' ? $p_nav_btn : $nav_btn;

        if( $nav_btn == '1' ){
            $nav_login_t = $softing[ 'nav_btn1_title' ];
            $nav_login_url = $softing[ 'nav_btn1_url' ];
            $nav_login_target = $softing[ 'nav_btn1_target' ] != '' ? $softing[ 'nav_btn1_target' ]  : '';
            $p_nav_login_t = rwmb_meta( 'softing_page_nav_btn1_title' );
            $p_nav_login_url = rwmb_meta( 'softing_page_nav_btn1_url' );
            $p_nav_login_target = rwmb_meta( 'softing_page_nav_btn1_target' );
            $nav_login_t = is_page() && $p_nav_login_t != '' ? $p_nav_login_t : $nav_login_t;
            $nav_login_url = is_page() && $p_nav_login_url != '' ? $p_nav_login_url : $nav_login_url;
            $nav_login_target = is_page() && $p_nav_login_target != '' ? $p_nav_login_target : $nav_login_target;

            $nav_try_t = $softing[ 'nav_btn2_title' ];
            $nav_try_url = $softing[ 'nav_btn2_url' ];
            $nav_try_target = $softing[ 'nav_btn2_target' ] != '' ? $softing[ 'nav_btn2_target' ] : '';
            $p_nav_try_t = rwmb_meta( 'softing_page_nav_btn2_title' );
            $p_nav_try_url = rwmb_meta( 'softing_page_nav_btn2_url' );
            $p_nav_try_target = rwmb_meta( 'softing_page_nav_btn2_target' );
            $nav_try_t = is_page() && $p_nav_try_t != '' ? $p_nav_try_t : $nav_try_t;
            $nav_try_url = is_page() && $p_nav_try_url != '' ? $p_nav_try_url : $nav_try_url;
            $nav_try_target = is_page() && $p_nav_try_target != '' ? $p_nav_try_target : $nav_try_target;
            ?>

            <div class="attr-nav button">
                <ul>

                    <?php if( $nav_login_t ){ ?>
                        <li>
                            <a href="<?php echo esc_url( $nav_login_url ); ?>" target="<?php echo esc_attr( $nav_login_target ); ?>"><?php echo esc_html( $nav_login_t ); ?></a>
                        </li>
                    <?php } ?>

                    <?php if( $nav_try_t ) { ?>
                        <li>
                            <a href="<?php echo esc_url( $nav_try_url ); ?>" target="<?php echo esc_attr( $nav_try_target ); ?>"><?php echo esc_html( $nav_try_t ); ?></a>
                        </li>
                    <?php } ?>

                </ul>
            </div>
            <?php
        }
    }
}

/*************************************************
## START FOOTER AND WIDGET-AREA
*************************************************/

if ( ! function_exists( 'softing_footer' ) ) {
    function softing_footer() {

        global $softing;

        //footer widget-area var
        $fw = $softing['footer_widgetize_onoff'];
        $pfw = rwmb_meta('softing_page_fw_onoff');
        $fw_d = is_page() && $fw != '0' ? $pfw : $fw ;
        $d_w = $softing['default_widgets'];
        $c_w = $softing['custom_widgets'];

        $fw_off = $fw_d == '1' ? ' default-padding' : '';
        $f_pad = $fw_d == '1' ? '' : ' ptb-40 mt-0';

        //footer copyright var
        $footer = $softing['footer_onoff'];
        $p_footer = rwmb_meta('page_footer_onoff');
        $footer_d = is_page() && $p_footer != '' ? $p_footer : $footer;
        $footer_type = $softing['footer_type'];
        $copy_text = $softing['footer_copyright'];

        ?>

        <footer class="bg-light<?php echo esc_attr( $fw_off ); ?>">

            <?php if ( $fw_d == '1' ) { ?>

                <!-- Footer Widget Area -->
                <div class="nt-footer-sidebar footer-widget-area">
                    <!-- container -->
                    <div class="container">
                        <!-- Row -->
                        <div class="row">
                            <div class="f-items">

                                <?php
                                // widgetize footer custom sidebar by custom column
                                if( $d_w != '1' ){

                                    for ( $i=0;  $i <= (count( $c_w )-1); $i++ ) {

                                        $column = $c_w[$i];
                                        $number = $i + 1;
                                        $id = 'custom-footer-widget-'.$number;

                                        if ( is_active_sidebar( $id)){

                                            echo'<div class="col-md-'.$column.' '.$id.'">';
                                            dynamic_sidebar( $id );
                                            echo'</div>';

                                        }
                                    }
                                }

                                // widgetize footer default sidebar
                                if( $d_w != '0' ){
                                    if ( is_active_sidebar( 'softing-footer-widget-1' )){
                                        dynamic_sidebar( 'softing-footer-widget-1' );
                                    }
                                    if ( is_active_sidebar( 'softing-footer-widget-2' )){
                                        dynamic_sidebar( 'softing-footer-widget-2' );
                                    }
                                    if ( is_active_sidebar( 'softing-footer-widget-3' )){
                                        dynamic_sidebar( 'softing-footer-widget-3' );
                                    }
                                    if ( is_active_sidebar( 'softing-footer-widget-4' )){
                                        dynamic_sidebar( 'softing-footer-widget-4' );
                                    }
                                }
                                ?>

                            </div>
                        </div>
                        <!-- End Row -->
                    </div>
                    <!-- End Container -->
                </div>
                <!-- End Footer Widget Area -->

            <?php } //end widget area display


            if ( $footer_d != '0' ) {

                if ( 'custom' == $footer_type ) {

                    //custom footer allowed html
                    echo  do_shortcode( softing_settings( 'custom_footer' ) );

                } elseif ( 'page' == $footer_type ) {

                    $ftemplate = softing_settings( 'footer_custom_page' );

                    if ( '' != $ftemplate && function_exists( 'softing_vc_inject_shortcode_css' ) ) {
                        softing_vc_inject_shortcode_css( $ftemplate );
                        $content = get_post_field( 'post_content', $ftemplate );
                        echo '<footer class="footer-template-'.$ftemplate.'">'.do_shortcode( $content ).'</footer>';
                    }

                } else {
                    ?>
                    <div class="nt-footer footer-bottom<?php echo esc_attr( $f_pad ); ?>">
                        <div class="container">
                            <div class="row">

                                <div class="col-lg-6 col-md-6 nt-copyright">

                                    <?php if ( $copy_text != '' ) {

                                        echo  do_shortcode( $copy_text );

                                    } else { ?>

                                        <p><?php echo esc_html_e('Copyright 2019. All Rights Reserved by', 'softing'); ?> <a href="#"><?php echo esc_html_e('Ninetheme.', 'softing'); ?></a></p>

                                    <?php } ?>

                                </div>

                                <div class="col-lg-6 col-md-6 text-right link">
                                    <ul>
                                        <?php
                                        //default wp menu
                                        wp_nav_menu( array(
                                            'menu'            => '',
                                            'theme_location'  => 'footer_menu',
                                            'container'       => '', // menu wrapper element
                                            'container_class' => '',
                                            'container_id'    => '',  // default: none
                                            'menu_class'      => '', // ul class
                                            'menu_id'         => '', // ul id
                                            'items_wrap'      => '%3$s',
                                            'before'          => '', // before <a>
                                            'after'           => '', // after <a>
                                            'link_before'     => '', // inside <a>, before text
                                            'link_after'      => '', // inside <a>, after text
                                            'depth'           => 1, // '0' to display all depths
                                            'echo'=> true,
                                            'fallback_cb'     => 'Softing_Wp_Bootstrap_Navwalker::fallback',
                                            'walker'          => new Softing_Wp_Bootstrap_Navwalker()
                                        )
                                    );
                                    ?>
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
                <?php
                } //end default footer
            }//end default footer display
            ?>
        </footer>
        <?php
    }
}
add_action( 'softing_footer_action',  'softing_footer', 10 );


/*************************************************
## START CUSTOM FOOTER HTML ALLOWED
*************************************************/

if ( ! function_exists( 'softing_custom_footer' ) ) {
    function softing_custom_footer() {
        global $softing;
        if(isset($softing['custom_footer']) && !empty($softing['custom_footer'])){
            return $softing['custom_footer'];
        } else {
            return false;
        }
    }
}

/*************************************************
## START FOOTER SOCIALS
*************************************************/

if ( ! function_exists( 'softing_footer_socials' ) ) {
    function softing_footer_socials() {
        global $softing;
        if(isset($softing['footer_socials']) && !empty($softing['footer_socials']) ){
            return $softing['footer_socials'];
        } else {
            return false;
        }
    }
}


/**********************************
## THEME PARTS
/**********************************/

function softing_allowed_html() {

    $allowed_tags = array(
        'a' => array(
            'class' => array(),
            'href'  => array(),
            'rel'   => array(),
            'title' => array(),
            'target' => array(),
        ),
        'abbr' => array(
            'title' => array(),
        ),
        'iframe' => array(
            'src' => array(),
        ),
        'b' => array(),
        'br' => array(),
        'blockquote' => array(
            'cite'  => array(),
        ),
        'cite' => array(
            'title' => array(),
        ),
        'code' => array(),
        'del' => array(
            'datetime' => array(),
            'title' => array(),
        ),
        'dd' => array(),
        'div' => array(
            'class' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'dl' => array(),
        'dt' => array(),
        'em' => array(),
        'h1' => array(),
        'h2' => array(),
        'h3' => array(),
        'h4' => array(),
        'h5' => array(),
        'h6' => array(),
        'i' => array(
            'class'  => array(),
        ),
        'img' => array(
            'alt'    => array(),
            'class'  => array(),
            'height' => array(),
            'src'    => array(),
            'width'  => array(),
        ),
        'li' => array(
            'class' => array(),
        ),
        'ol' => array(
            'class' => array(),
        ),
        'p' => array(
            'class' => array(),
        ),
        'q' => array(
            'cite' => array(),
            'title' => array(),
        ),
        'span' => array(
            'class' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'strike' => array(),
        'strong' => array(),
        'ul' => array(
            'class' => array(),
        ),
    );
    return $allowed_tags;
}


/*************************************************
## START PRELOADER
*************************************************/

if ( ! function_exists( 'softing_preloader' ) ) {
    function softing_preloader() {

        global $softing;

        $pre_onoff = isset($softing['pre_onoff']) ? $softing['pre_onoff'] : '1';

        if ( $pre_onoff != '0' ) {

            $pre_type = isset($softing['pre_type']) ? $softing['pre_type'] : 'default';

            if ( $pre_type == 'default' ) { ?>

                <!-- Preloader Start -->
                <div class="se-pre-con"></div>
                <!-- Preloader Ends -->

            <?php } else { ?>

                <div id="nt-preloader" class="preloader">
                    <div class="loader<?php echo esc_attr( $pre_type ); ?>"></div>
                </div>
                <?php
            }
        }
    }
}


/*************************************************
##  BACKTOP
*************************************************/

if ( ! function_exists( 'softing_backtop' ) ) {
    function softing_backtop() {

        global $softing;

        $opt = $softing['backtotop_onoff'];

        if ( $opt != '0' ) {

            wp_enqueue_script('scrollUp');
            wp_enqueue_script('scrollup-custom');

        }
    }
}


/*************************************************
##  CONTENT NONE
*************************************************/

if ( ! function_exists( 'softing_content_none' ) ) {
    function softing_content_none() {
        ?>
        <div class="content-none-container">

            <h3 class="page-title"><?php esc_html_e( 'Nothing Found', 'softing' ); ?></h3>

            <?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
                <p><?php printf( esc_html__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'softing' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
            <?php elseif ( is_search() ) : ?>
                <p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'softing' ); ?></p>
                <?php get_search_form(); ?>
            <?php else : ?>
                <p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'softing' ); ?></p>
                <?php get_search_form(); ?>
            <?php endif; ?>

        </div> <!-- End article -->
        <?php
    }
}
