<?php

if ( is_admin() )
return false;

/*************************************************
##  FORMATS_CONTENT
*************************************************/

if ( ! function_exists( 'softing_post_format' ) ) {
	function softing_post_format() {

		global $softing;

		//add sticky class to post if post sticked
		$sticky = ( is_sticky() ) ? ' -has-sticky ' : '';

		//post format
		$format = get_post_format() ? : 'standard';

		//post title on-off
		$title = isset($softing['post_title']) && !empty($softing['post_title']) ? $softing['post_title'] : '1';

		//post alignment
		$alignment = ( isset($softing['post_alignment'] ) && !empty($softing['post_alignment']) ) ? ' '.$softing['post_alignment'] : ' text-left';

		//post excerpt on-off and customize excerpt size
		$excerpt = isset($softing['post_excerpt']) && !empty($softing['post_excerpt']) ? $softing['post_excerpt'] : '1';
		$excerptsz = isset($softing['excerptsz']) && !empty($softing['excerptsz']) ? $softing['excerptsz'] : 80;

		//post read-more button
		$button = isset($softing['post_button']) && !empty($softing['post_button']) ? $softing['post_button'] : '1';

		$blog_layout = isset($softing['index_layout']) && $softing['index_layout'] != '' ? $softing['index_layout'] : 'right-sidebar';

	?>


	<div id="post-<?php the_ID(); ?>" <?php post_class( esc_attr( 'nt-post equal-height '.$alignment.' '. esc_attr( $sticky ) ) ); ?> >

		<div class="item">

			<?php

				if ( 'video' == $format ){

					$icon = 'fas fa-video';

				}elseif ( 'audio' == $format ){

					$icon = 'fas fa-music';

				}elseif ( 'gallery' == $format ){

					$icon = 'fas fa-images';

				} else {

					$icon = 'fas fa-image';

				}

				//post format video or audio embed
				if ( 'video' == $format || 'audio' == $format ) {

					$content = rwmb_meta( 'softing_embed_content' );

					// Only get video from the content if a playlist isn't present.
					if ( false === strpos( $content, 'wp-playlist-script' ) ) {
						$embed = get_media_embedded_in_content( $content, array( 'video', 'object', 'embed', 'iframe' ) );
					}

					// If not a single post, highlight the video file.
					if ( ! empty( $embed ) ) {
						foreach ( $embed as $embed_html ) {

							echo '<div class="thumb embed-responsive embed-responsive-16by9">'.$embed_html.'<div class="post-type"><i class="'.$icon.'"></i></div></div>';

						}
					}

				//post format gallery
				}elseif ( 'gallery' == $format ) {

					wp_enqueue_style( 'owl-carousel');
					wp_enqueue_style( 'owl-default');
					wp_enqueue_script('owl-carousel');
					wp_enqueue_script('carousel-custom');

					$images = rwmb_meta( 'softing_gallery', array( 'size' => 'full', 'type' => 'image_advanced' ) );
					if( $images ) {

						echo '<div class="post-gallery-active owl-carousel">';

							foreach ( $images as $image ) {
								echo '<div class="thumb post-gallery-item"><a href="'.esc_url( get_permalink() ).'"><img src="'.esc_url( $image['full_url'] ).'" alt="'.esc_attr( $image['alt'] ).'"><div class="post-type"><i class="fa fa-image"></i></div></a></div>';
							}

						echo '</div>';

					}

				//standart post
				} else {

					if ( has_post_thumbnail() ) {

						$thumbnail = get_the_post_thumbnail_url(get_the_ID(),'full');

						?>

						<div class="thumb"><a href="<?php echo esc_url( get_permalink() ); ?>"><img class="img-fluid" src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php the_title_attribute(); ?>"><div class="post-type"><i class="fa fa-image"></i></div></a></div>

						<?php

					}

				}

			//post content wrapper div
			echo '<div class="info">';

				// post title
				if ( $title != '0' ) {

					the_title( sprintf( '<h3 class="nt-post-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );

				}

				if ( ! is_search() ) {

					// post meta = category - author - date
					softing_post_meta();

				}

				// post content function for loop excerpt.
				if ( $excerpt != '0' ) {

					echo '<div class="post-excerpt">'.wpautop( softing_excerpt_limit($excerptsz) ).'</div>';

				}

				// post read-more button.
				if ( $button != '0' ) {

					echo '<a href="'.esc_url( get_permalink() ).'" class="btn circle btn-theme effect btn-sm">'.esc_html__( 'Read More', 'softing' ).'</a>';

				}

				// this function must be using for wp linkable pages, don't delete!
				softing_wp_link_pages();

			?>

			</div>
			<!-- end post content wrapper div -->

		</div>

	</div>

<?php
	}
}

/*************************************************
##  POST/CPT META
*************************************************/
if ( ! function_exists( 'softing_post_meta' ) ) {
	function softing_post_meta() {

		global $softing, $post;

		$archive_year  = get_the_time( 'Y' );
		$archive_month = get_the_time( 'm' );
		$archive_day   = get_the_time( 'd' );
		$author_id 	   = get_the_author_meta( 'ID' );
		$author_link   = get_author_posts_url( $author_id );

		//post meta on-off
		$post_meta = isset($softing['post_meta'] ) && !empty($softing['post_meta']) ? $softing['post_meta'] : '1';
		$post_author = isset($softing['post_author']) && !empty($softing['post_author']) ? $softing['post_author'] : '1';
		$post_date = isset($softing['post_date']) && !empty($softing['post_date']) ? $softing['post_date'] : '1';
		$post_cat = isset($softing['post_category']) && !empty($softing['post_category']) ? $softing['post_category'] : '1';


		if ( $post_meta != '0' ) { ?>

		<div class="meta mt-0">

			<!-- Post Category, Author, Comments -->
			<ul>

				<?php


			 	if ( is_sticky() ) {
					echo '<div class="sticky-label">'.esc_html__( 'Sticky', 'softing' ).'</div>';
				}

				//post date
				if ( $post_date != '0' ) { ?>

					<li><a class="post-date" href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><i class="fa fa-calendar"></i> <?php the_time( get_option( 'date_format' )); ?></a></li>

				<?php }

				//post author
				if ( $post_author != '0' ) { ?>

					<li><a class="post-author" href="<?php echo esc_url( $author_link ); ?>"><i class="fa fa-user"></i> <?php the_author(); ?></a></li>

				<?php }

				//post comments count
				if ( $post_cat != '0' ) { ?>

					<li><a class="post-comment" href=""><i class="fa fa-comments"></i> <?php comments_number(); ?></a></li>

				<?php } ?>

			</ul>
		</div>

	<?php }
	}
}

/*************************************************
##  SINLGE POST/CPT CONTENT
*************************************************/

if ( ! function_exists( 'softing_single_post_content' ) ) {
function softing_single_post_content() {

	global $softing, $post;

	$archive_year  = get_the_time( 'Y' );
	$archive_month = get_the_time( 'm' );
	$archive_day   = get_the_time( 'd' );

	$author_id     = $post->post_author;
	$author_link   = get_author_posts_url( $author_id );
	$author_name   = get_the_author_meta('display_name', $author_id );

	//post format
	$format = get_post_format() ? : 'standard';

	//post all meta on-off
	$post_all_meta = isset($softing['single_post_meta_onoff']) ? $softing['single_post_meta_onoff'] : '1';

	//simple post category on-off
	$post_cat = isset($softing['single_post_cats_onoff']) ? $softing['single_post_cats_onoff'] : '1';

	//simple post author on-off
	$post_author = isset($softing['single_post_author_onoff']) ? $softing['single_post_author_onoff'] : '1';

	//simple post date on-off
	$post_date = isset($softing['single_post_date_onoff']) ? $softing['single_post_date_onoff'] : '1';

	//simple post comments on-off
	$post_comments = isset($softing['single_post_comments_onoff']) ? $softing['single_post_comments_onoff'] : '1';

	$single_layout = isset($softing['single_layout']) && $softing['single_layout'] != '' ? $softing['single_layout'] : 'right-sidebar';

?>

	<!-- Post featured thumbnail image -->

	<?php

		if ( 'video' == $format ){

			$icon = 'fas fa-video';

		}elseif ( 'audio' == $format ){

			$icon = 'fas fa-music';

		}elseif ( 'gallery' == $format ){

			$icon = 'fas fa-images';

		} else {

			$icon = 'fas fa-image';

		}
		//post format video or audio embed
		if ( 'video' == $format || 'audio' == $format ) {

			$content = rwmb_meta( 'softing_embed_content' );

			// Only get video from the content if a playlist isn't present.
			if ( false === strpos( $content, 'wp-playlist-script' ) ) {
				$embed = get_media_embedded_in_content( $content, array( 'video', 'object', 'embed', 'iframe' ) );
			}

			// If not a single post, highlight the video file.
			if ( ! empty( $embed ) ) {
				foreach ( $embed as $embed_html ) {

					echo '<div class="thumb embed-responsive embed-responsive-16by9">'.$embed_html.'<div class="post-type"><i class="'.$icon.'"></i></div></div>';

				}
			}

		//post format gallery
		}elseif ( 'gallery' == $format ) {

			wp_enqueue_style( 'owl-carousel');
			wp_enqueue_script('owl-carousel');
			wp_enqueue_script('carousel-custom');

			$images = rwmb_meta( 'softing_gallery', array( 'size' => 'full', 'type' => 'image_advanced' ) );
			if( $images ) {

				echo '<div class="post-gallery-active owl-carousel">';

					foreach ( $images as $image ) {
						echo '<div class="thumb post-gallery-item">
						<a href="'.esc_url( get_permalink() ).'"><img src="'.esc_url( $image['full_url'] ).'" alt="'. esc_attr( $image['alt'] ) .'"><div class="post-type"><i class="'. esc_attr( $icon ).'"></i></div></a>
						</div>';
					}

				echo '</div>';

			}

		//standart post
		} else {

			if ( has_post_thumbnail() ) {

				$thumbnail = get_the_post_thumbnail_url(get_the_ID(),'full');

				?>

				<div class="thumb">
					<img class="img-fluid" src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php the_title_attribute(); ?>">
					<div class="post-type">
						<i class="fa fa-image"></i>
					</div>
				</div>

				<?php

			}

		}

	echo '<div class="info">';
		//Post Meta
		if ( $post_all_meta == '1' ) {
		echo '<div class="meta mt-0">
				<ul>';

			//post date
			if ( $post_date != '0' ) {

				printf( '<li><a class="post-date" href="%1$s"><i class="fa fa-calendar"></i> %2$s </a></li>',
					esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ),
					get_the_time( get_option( 'date_format' ))
				);

			}

			//post author
			if ( $post_author == '1' ) {

				printf( '<li><a class="post-author" href="%1$s"><i class="fa fa-user"></i> %2$s </a></li>',
					esc_url( $author_link ),
					get_the_author_meta('display_name', $author_id )
				);

			}

			//post author
			if ( $post_cat != '0' && has_category() ) {
			?>

				<li><i class="fa fa-tags"></i> <?php the_category(', '); ?> </li>

			<?php

			}

		echo '</ul>

		</div>';

		} //end post meta

		echo '<div class="post-content nt-clearfix">';

			// post content function for loop excerpt.
			the_content();

		echo '</div>';

		// this function must be using for wp linkable pages, don't delete!
		softing_wp_link_pages();

		// Post tags 1 = on and 0 = off
		softing_single_post_tags();

		?>

<?php
}
}

/*************************************************
##  SINLGE POST/CPT TAGS
*************************************************/

if ( ! function_exists( 'softing_single_post_tags' ) ) {
	function softing_single_post_tags() {

		global $softing;
		$post_tags = isset($softing['single_post_tags_onoff']) && !empty($softing['single_post_tags_onoff']) ? $softing['single_post_tags_onoff'] : '1';

		if ( $post_tags == '1' ) {

			if( has_tag() ) {
			?>
				<!-- Post Tags -->
				<div class="post-tags">

					<span><?php esc_html_e( 'Tags :', 'softing' ); ?> </span>

					<?php
						$tags = get_the_tags(get_the_ID());
						foreach($tags as $tag){
							echo '<a class="'. esc_attr( $tag->name ) .'" href="'.esc_url( get_tag_link( $tag->term_id ) ).'">'. esc_html( $tag->name ) .'</a>';
						}
					?>

				</div>
				<!-- Post Tags End -->
			<?php
			}
		}
	}
}


/*************************************************
## SINGLE POST AUTHOR BOX FUNCTION
*************************************************/

if( ! function_exists('softing_single_post_author_box') ){
function softing_single_post_author_box(){

	global $post,$softing;

	$opt = $softing['post_authorbox_onoff'];

	if ( $opt != '0' ) {

	// Get author's display name
	$display_name = get_the_author_meta( 'display_name', $post->post_author );

	// If display name is not available then use nickname as display name
	if ( empty( $display_name ) )
	$display_name = get_the_author_meta( 'nickname', $post->post_author );

	// Get author's biographical information or description
	$user_description = get_the_author_meta( 'user_description', $post->post_author );

	// Get author's website URL
	$user_website = get_the_author_meta('url', $post->post_author);

	// Get link to the author archive page
	$user_posts = get_author_posts_url( get_the_author_meta( 'ID' , $post->post_author));

	// Get the rest of the author links. These are stored in the
	// wp_usermeta table by the key assigned in wpse_user_contactmethods()
	$author_facebook = get_the_author_meta( 'facebook', $post->post_author );
	$author_twitter  = get_the_author_meta( 'twitter', $post->post_author  );
	$author_linkedin = get_the_author_meta( 'linkedin', $post->post_author );
	$author_youtube  = get_the_author_meta( 'youtube', $post->post_author  );

	if ( $user_description != '') {
?>

	<div class="author mt-30">
		<div class="author-img">
			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
				<?php if( function_exists('get_avatar') ) { echo get_avatar( get_the_author_meta('email'), '100' ); } ?>
			</a>
		</div>
		<div class="author-text">
			<h4><a href="<?php echo  esc_url( $user_posts ); ?>"><?php echo esc_html( $display_name ); ?></a></h4>
			<p><?php echo esc_html( $user_description ); ?></p>
			<div class="author-icon">

				<?php if ( $author_facebook != '') { ?>
					<a href="<?php echo  esc_url( $author_facebook ); ?>" target="_blank"><i class="fab fa-facebook-f" aria-hidden="true"></i></a>
				<?php } ?>
				<?php if ( $author_twitter != '') { ?>
					<a href="<?php echo  esc_url( $author_twitter ); ?>" target="_blank"><i class="fa fa-twitter" aria-hidden="true"></i></a>
				<?php } ?>
				<?php if ( $author_linkedin != '') { ?>
					<a href="<?php echo  esc_url( $author_linkedin ); ?>" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
				<?php } ?>
				<?php if ( $author_youtube != '') { ?>
					<a href="<?php echo  esc_url( $author_youtube ); ?>" target="_blank"><i class="fa fa-youtube" aria-hidden="true"></i></a>
				<?php } ?>
			</div>
		</div>
	</div>

<?php
}
}
}
}

/*************************************************
## SINGLE POST RELATED POSTS
*************************************************/

if( ! function_exists('softing_single_post_related') ){
function softing_single_post_related(){

	global $softing;
	$s_r = $softing['single_related_onoff'];

	if ( $s_r == '1' ) {

	global $post;
	$tags = wp_get_post_tags( $post->ID );

	if ($tags) {
?>

	<div class="single-post-related mt-30">

		<h3 class="page-post-2-title"><?php echo esc_html_e( 'You Might Also Like','softing' );?></h3>

		<div class="row">

			<?php
				$tag_ids = array();
				foreach( $tags as $individual_tag )
				$tag_ids[] = $individual_tag->term_id;
				$args=array(
					'tag__in' => $tag_ids,
					'post__not_in' => array($post->ID),
					'posts_per_page'=>3, // Number of related posts to display.	'caller_get_posts'=>1	);
				);
				$like_query = new wp_query( $args );
				while( $like_query->have_posts() ) {
				$like_query->the_post();
			?>
				<div class="col-md-4 col-sm-4">
					<div class="also-like-inner">
						<?php if( has_post_thumbnail() ) {	?>
							<a href="<? the_permalink()?>"><?php the_post_thumbnail(array(200,200)); ?></a>
							<div class="u-space-20"></div>
						<?php } ?>
						<h5 class="also-like-title"><a class="u-color-dark"  href="<? the_permalink()?>"><?php the_title(); ?></a></h5>
						<h6 class="also-like-time u-color-grey"><?php the_time('F j, Y'); ?></h6>
					</div>
				</div>

			<?php
				}

				wp_reset_postdata();
			?>

		</div>

	</div>

<?php
}
}
}
}
/*************************************************
## SINGLE PORTFOLIO POST RELATED POSTS
*************************************************/

if( ! function_exists('softing_single_port_related') ){
function softing_single_port_related(){

	global $softing;
	$s_p_r = $softing['single_port_related_onoff'];

	if ( $s_p_r == '1' ) {
		$relatedtitle = isset($softing['related_port_title']) && !empty($softing['related_port_title']) ? $softing['related_port_title'] : '';
		$relatedperpage = isset($softing['related_port_perpage']) && !empty($softing['related_port_perpage']) ? $softing['related_perpage'] : 3;

		// related post
		$port_related = get_posts( array(
		'category__in' 	=> wp_get_post_categories($post->ID),
		'numberposts' 	=> $relatedperpage,
		'post_type' 	=> 'portfolio',
		'post__not_in' 	=> array($post->ID)
		));

?>

		<div class="single-post-related">

			<h2 class="related-title f-normal ultrabold dark"><?php echo esc_html( $relatedtitle );?></h2>

			<div class="separator-small colored-2-bg"></div>

			<div class="row"  data-uk-scrollspy="{cls:'uk-animation-fade'}">

			<?php foreach( $port_related as $post ) {
				setup_postdata($post);
				$img_url = wp_get_attachment_url( get_post_thumbnail_id(),'full' );
			?>
				<!-- Work -->
				<div class="col-md-4">
					<img src="<?php echo esc_url($img_url); ?>" alt="<?php the_title_attribute(); ?>" />
					<h3 class="f-normal dark ultrabold"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
				</div>

			<?php } wp_reset_postdata();?>
			</div>
		</div>


<?php

}
}
}
