<?php

if ( is_admin() )
return false;

/**
 * Custom paginations for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package softing
*/



// next post css class
function softing_posts_next_pag_attrs() {
  return 'class="c-pagination-1-link -next"';
}
add_filter('next_posts_link_attributes', 'softing_posts_next_pag_attrs');

// prev post css class
function softing_posts_prev_pag_attrs() {
  return 'class="c-pagination-1-link -previous"';
}
add_filter('previous_posts_link_attributes', 'softing_posts_prev_pag_attrs');



/*************************************************
##  SINLGE POST/CPT NAVIGATION - Display navigation to next/previous post when applicable.
*************************************************/

if ( ! function_exists( 'softing_single_navigation' ) ) {
function softing_single_navigation() {
  global $softing;

  $opt = $softing[ 'single_navigation_onoff' ];

  if ( $opt != '0' ) {
  	// Don't print empty markup if there's nowhere to navigate.
  	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
  	$next     = get_adjacent_post( false, '', false );

  	if ( ! $next && ! $previous ) {
  		return;
  	}
  	?>

  	<div class="post-pagi-area">
		<?php previous_post_link( '%link', _x( '<i class="fa fa-arrow-left"></i> Previous Post ', 'Previous post link', 'softing' ) ); ?>
  		<?php next_post_link( '%link', _x( 'Next Post <i class="fa fa-arrow-right"></i>', 'Next post link', 'softing' ) ); ?>

  	</div>
  	<?php
	}
  }
}


/*************************************************
## POST PAGINATION - Display post navigation to next/previous post when applicable.
*************************************************/

function softing_index_loop_pagination() {

  global $softing;

  $opt = $softing[ 'pag_onoff' ];

  if ( $opt != '0' ) {

  $type 	= $softing[ 'pag_type' ];
  $size 	= $softing[ 'pag_size' ];
  $group 	= $softing[ 'pag_group' ];
  $corner 	= $softing[ 'pag_corner' ];
  $align 	= $softing[ 'pag_align' ];

  $groupo		= ( $group == 'yes' ) ? ' -group' : '';
  $typeo		= ( $type == '' ) ? 'default' : ''.$type.'';
  $sizeo		= ( $size == '' ) ? 'medium' : ''.$size.'';
  $aligno		= ( $align == '' ) ? 'left' : ''.$align.'';
  $cornero	= ( $corner == '' ) ? 'square' : ''.$corner.'';
  $prev			= get_previous_posts_link('<i class="c-pagination-1-icon fa fa-angle-left" aria-hidden="true"></i>');
  $next			= get_next_posts_link('<i class="c-pagination-1-icon fa fa-angle-right" aria-hidden="true"></i>');

    if( is_singular() )
        return;

    global $wp_query;

    /** Stop execution if there's only 1 page */
    if( $wp_query->max_num_pages <= 1 )
        return;

    $paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
    $max   = intval( $wp_query->max_num_pages );

    /** Add current page to the array */
    if ( $paged >= 1 )
        $links[] = $paged;

    /** Add the pages around the current page to the array */
    if ( $paged >= 3 ) {
        $links[] = $paged - 1;
        $links[] = $paged - 2;
    }

    if ( ( $paged + 2 ) <= $max ) {
        $links[] = $paged + 2;
        $links[] = $paged + 1;
    }

    echo "<div class='c-pagination-1 -style-".esc_attr( $typeo )." -size-".esc_attr( $sizeo )." -align-".esc_attr( $aligno )." -corner-".esc_attr( $cornero )." ".esc_attr( $groupo )." '><ul class='c-pagination-1-inner'>" . "\n";

    /** Previous Post Link */
    if ( get_previous_posts_link() )
        echo '<li class="c-pagination-1-item">' . wp_kses( $prev, softing_allowed_html() ) . '</li>';

    /** Link to first page, plus ellipses if necessary */
    if ( ! in_array( 1, $links ) ) {
        $class = 1 == $paged ? ' active' : '';

        printf( '<li class="c-pagination-1-item%s" ><a class="c-pagination-1-link" href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( 1 ) ), '1' );

        if ( ! in_array( 2, $links ) )
            echo '<li class="c-pagination-1-item">…</li>';
    }

    /** Link to current page, plus 2 pages in either direction if necessary */
    sort( $links );
    foreach ( (array) $links as $link ) {
        $class = $paged == $link ? ' active' : '';
        printf( '<li class="c-pagination-1-item%s" ><a class="c-pagination-1-link" href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
    }

    /** Link to last page, plus ellipses if necessary */
    if ( ! in_array( $max, $links ) ) {
        if ( ! in_array( $max - 1, $links ) )
            echo '<li class="c-pagination-1-item">…</li>' . "\n";

        $class = $paged == $max ? ' active' : '';
        printf( '<li class="c-pagination-1-item%s" ><a class="c-pagination-1-link" href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $max ) ), $max );
    }

    /** Next Post Link */
    if ( get_next_posts_link() )
        echo '<li class="c-pagination-1-item">' . wp_kses( $next, softing_allowed_html() ) . '</li>';

    echo '</ul></div>' . "\n";

  }
}


/*************************************************
##  LINK PAGES CURRENT CLASS
*************************************************/


function softing_current_link_pages( $link ) {
  if ( ctype_digit( $link ) ) {
    return '<span class="current">' . $link . '</span>';
  }
  return $link;
}
add_filter( 'wp_link_pages_link', 'softing_current_link_pages' );


/*************************************************
##  LINK PAGES
*************************************************/


if ( ! function_exists( 'softing_wp_link_pages' ) ) {
	function softing_wp_link_pages() {

		// pagination for page links
		wp_link_pages( array(

			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages', 'softing' ) . '</span>',
			'after'       => '</div>',
			'link_before'      => '',
			'link_after'       => '',
			'next_or_number'   => 'number',
			'separator'        => ' ',
			'nextpagelink'     => esc_html__( 'Next page', 'softing' ),
			'previouspagelink' => esc_html__( 'Previous page', 'softing' ),
			'pagelink'         => '%',
			'echo'             => 1

			)
		);

	}
}
