<?php

if ( is_admin() )
return false;


/*************************************************
## HERO FUNCTION
*************************************************/

if(! function_exists('softing_hero_section')){
	function softing_hero_section(){

	global $softing;

	if ( is_404() ) { // error page
		$name = 'error';
		$h_t = esc_html__( '404 - Not Found', 'softing' );
	}elseif ( is_archive() ) { // blog and cpt archive page
		$name = 'archive';
		$h_t = softing_archive_title();
	}elseif ( is_search() ) { // search page
		$name = 'search';
		$h_t = esc_html__( 'Search Results for :', 'softing' ) ." ". get_search_query();
	}elseif ( is_home() OR is_front_page() ) { // blog post loop page index.php or your choise on settings
		$name = 'blog';
		$h_t = get_bloginfo('name');
	}elseif ( is_single() AND ! is_singular('portfolio') ) { // blog post single/singular page
		$name = 'single';
		$h_t = get_the_title();
	}elseif ( is_singular('portfolio') ) { // it is cpt and if you want use another clone this condition and add your cpt name as portfolio
		$name = 'single_portfolio';
		$h_t = get_the_title();
	}elseif ( is_page() ) {	// default or custom page
		$name = 'page';
		$h_t = get_the_title();
	}

	// page hero display
	if( is_page() ){

		$h_v = ( rwmb_meta('softing_page_hero_display') != '' ) ? rwmb_meta('softing_page_hero_display') : '1';
		//page title
		$h_t = ( rwmb_meta('softing_page_heading') != '' ) ? rwmb_meta('softing_page_heading') : $h_t;
		//page slogan
		$h_s = ( rwmb_meta('softing_page_slogan') != '' ) ? rwmb_meta('softing_page_slogan') : '';
		//page description
		$h_d = ( rwmb_meta('softing_page_desc') != '' ) ? rwmb_meta( 'softing_page_desc') : '';
		//page breadcrumbs
		$h_b = isset($softing['breadcrumbs']) ? $softing['breadcrumbs'] : '0';
		//page hero alignment
		$h_a = ( rwmb_meta('softing_page_hero_align') != '' ) ? rwmb_meta('softing_page_hero_align') : 'text-center';
		//page hero background image overlay pattern type
		$h_o = ( rwmb_meta('softing_page_hero_overlay_type') == 'custom' ) ? 'hero-overlay' : 'shadow-dark text-light';

	} else {

		$h_v = isset($softing[$name.'_hero']) ? $softing[$name.'_hero'] : '1';
		//page title
		$h_t = isset($softing[$name.'_title']) && $softing[$name.'_title'] != '' ? $softing[$name.'_title'] : $h_t;
		//page slogan
		$h_s = isset($softing[$name.'_slogan']) ? $softing[$name.'_slogan'] : '';
		//page description
		$h_d = isset($softing[$name.'_desc']) ? $softing[$name.'_desc'] : '';
		//page breadcrumbs
		$h_b = isset($softing['breadcrumbs']) ? $softing['breadcrumbs'] : '0';
		//page hero alignment
		$h_a = isset($softing[$name.'_hero_alignment']) && $softing[$name.'_hero_alignment'] != '' ? $softing[$name.'_hero_alignment'] : 'text-center';
		//page hero background image overlay pattern type
		$h_o = isset($softing[$name.'_hero_overlay_type']) && $softing[$name.'_hero_overlay_type'] == 'custom' ? 'hero-overlay' : 'shadow-dark text-light';

	}
	$ht_length = strlen($h_t) > 28 ? ' title-full' : '';
	if( $h_v != '0' &&  $h_t != '' ) {

		echo'<div id="nt-hero" class="page-id-'. get_the_ID() .' '. esc_attr( $name ) .'-hero breadcrumb-area bg-fixed padding-xl '. esc_attr( $h_o ) .' '. esc_attr( $h_a ) .'">
			<div class="container">
				<div class="row">
					<div class="col-lg-12 col-md-12">';

					// Title
					if( $h_t != '' ) {
						echo '<h1 class="hero-title'.$ht_length.'">'. wp_kses( $h_t, softing_allowed_html() ) . " " . get_search_query() . '</h1>';
					}

					// Slogan
					if( $h_s != '' && ! is_search() ) {
						echo '<h2 class="hero-subtitle">'. wp_kses( $h_s, softing_allowed_html() ) .'</h2>';
					}

					// Description
					if ( $h_d != '' ) {
						echo '<p class="hero-desc">'. wp_kses( $h_d, softing_allowed_html() ) .'</p>';
					}

					// Breadcrumbs
					if( $h_b != 0 ) { softing_breadcrumbs(); }

				echo '</div>
				</div>
			</div>
		</div>';

	} // hide hero area
  }
}
