<?php
   function softing_custom_css() {

   $softing = get_option('softing');
   if (  is_admin() || ( function_exists( 'vc_is_inline' ) && vc_is_inline() ) )
   return false;

  /* CSS to output */
  $theCSS = '';

  if( is_admin_bar_showing() && !is_customize_preview()) {
      $theCSS .= '
      .nt-site-header .sticked, .fixed-style:not(.no-background), .transparent-style{ top: 32px!important; }
      @media (max-width: 782px){
          .nt-site-header{ margin-top: 46px!important; }
          .fixed-style:not(.no-background), .transparent-style{ top: 46px!important; }
          .nt-site-header .sticked{ margin-top: 14px!important; }
          html.nt-theme-html-tag { margin-top: 0px!important; }
      }
      @media (max-width: 600px){
          .nt-site-header{ margin-top: 46px!important; }
          .transparent-style{ top: 46px!important; }
          .fixed-style:not(.no-background), .transparent-style:not(.navbar-transparent){ top: 0px!important; }
          .nt-site-header .sticked {
              margin-top: 0px!important;
              top: 0px!important;
          }
          html.nt-theme-html-tag { margin-top: 0px!important; }
      }';
  }

    /*************************************************
    ## Filter Function
    *************************************************/
    if ( !function_exists( 'softing_hex2rgb' ) ) {
        function softing_hex2rgb($hex) {
            $hex = str_replace("#", "", $hex);

            if(strlen($hex) == 3) {
                $r = hexdec(substr($hex,0,1).substr($hex,0,1));
                $g = hexdec(substr($hex,1,1).substr($hex,1,1));
                $b = hexdec(substr($hex,2,1).substr($hex,2,1));
            } else {
                $r = hexdec(substr($hex,0,2));
                $g = hexdec(substr($hex,2,2));
                $b = hexdec(substr($hex,4,2));
            }
            $rgb = array($r, $g, $b);

            return $rgb; // returns an array with the rgb values
        }
    }

    $main_color = $softing['theme_main_color'];
    if ( $main_color ) {
        $theCSS .= '.attr-nav > ul > li:last-child > a,
        .btn-theme.border:hover,
        .btn-theme,.video-play-button:after,
        .video-play-button:before,
        .list-info i,
        .list-info i:after,
        .site-heading h2::before,
        .wpb-js-composer .vc_tta.vc_general.vc_tta-style-theme li.vc_active a,
        .pricing-area .pricing-item.active .pricing-header,
        .blog-area .item .thumb .post-type,
        .subscribe-area .subscribe .input-group i,
        .contact-form .submit-btn,
        #scrollUp,
        .overview-area .overview-items .owl-dots .owl-dot.active span,
        .overview-area .overview-items .owl-dots .owl-dot:hover span,
        .team-area .team-carousel .owl-dots .owl-dot.active span,
        .team-area .team-carousel .owl-dots .owl-dot:hover span,
        .features-items i,
        .features-items i:after,
        .blog-area.single .post-pagi-area a,
        #reply-title:before,
        #comments .page-post-2-title:before,
        .c-comments-1-reply a,
        .c-button-1.-color-green-outline,
        #nt-sidebar .widget-title:before,
        .blog-items .c-pagination-1.-style-default .c-pagination-1-item.active .c-pagination-1-link,
        .blog-items .c-pagination-1.-style-default .c-pagination-1-link:hover,
        .bg-theme {
            background-color: '.$main_color.';
        }
        .banner-area .content h1 b,
        .btn-theme.border,
        .companies-area .clients-items .owl-nav .owl-prev,
        .companies-area .clients-items .owl-nav .owl-next,
        .pricing-item li i,
        .team-area .info span,
        .testimonial-items span,
        .testimonial-items span,
        .address-items i,
        .wpb-js-composer .vc_tta.vc_general.vc_tta-style-theme-accordion .vc_tta-controls-icon.vc_tta-controls-icon-chevron:before,
        footer .f-item .address li i,
        footer .footer-bottom p a,
        footer .f-item.link li a:hover,
        nav.navbar.bootsnav ul.nav > li > a:hover,
        nav.navbar.bootsnav ul.navbar-right li.dropdown ul.dropdown-menu li a:hover,
        .about-area:not(.primary-bg) .services-info .item i,
        .text-dark .video-play-button,
        .c-comments-1-date a,
        .nt-sidebar-inner-search-button:hover,
        .sidebar-widget a:hover,
        .attr-nav > ul > li > a,
        .blog-area .info a:hover,
        .blog-area .info .meta a:hover,
        .breadcrumb-area .breadcrumb li.active,
        .text-dark .video-play-button:hover,
        .text-dark .video-play-button:focus {
            color: '.$main_color.';
        }
        .btn-theme.border,
        .btn-theme.border:hover,
        .btn-theme,
        .c-button-1.-color-green-outline {
            border-color: '.$main_color.';
        }';
    }
    $secondary_color = $softing['theme_secondary_color'];
    if ( $secondary_color ) {
        $theCSS .= '.features-area .item .icon i,
        .wpb-js-composer .vc_tta.vc_general.vc_tta-style-theme .vc_tta-tab>a,
        .pricing-header,
        .testimonials-area .testimonial-items .item span.quote,
        footer .f-item .address li i,
        .blog-items .c-pagination-1.-style-default .c-pagination-1-link {
            background-color: '.$secondary_color.';
        }';
    }
	/*************************************************
	## PRELOADER SETTINGS
	*************************************************/

	if ( $softing[ 'pre_onoff'] != '0' ) {

		$pretype = $softing['pre_type'];
		$prebg   = ( $softing['pre_bg'] != '' ) ?  $softing['pre_bg']  : '#fff';
		$spinclr = ( $softing['pre_spin'] != '' ) ? $softing['pre_spin'] : '#4ac4f3';

		if ( $pretype != 'def' ) {
			$theCSS .= 'div#nt-preloader {background-color: '.esc_attr( $prebg ).';overflow: hidden;background-repeat: no-repeat;background-position: center center;height: 100%;left: 0;position: fixed;top: 0;width: 100%;z-index: 10000;}';

			$spinrgb   = softing_hex2rgb($spinclr);
			$spin_rgb  = implode(", ", $spinrgb);

			if ( $pretype == '01' ) {
				$theCSS .= '.loader01 {width: 56px;height: 56px;border: 8px solid '.$spinclr.';border-right-color: transparent;border-radius: 50%;position: relative;animation: loader-rotate 1s linear infinite;top: 50%;margin: -28px auto 0; }.loader01::after {content: \'\';width: 8px;height: 8px;background: '.$spinclr.';border-radius: 50%;position: absolute;top: -1px;left: 33px; }@keyframes loader-rotate {0% {transform: rotate(0); }100% {transform: rotate(360deg); } }';
			}
			if ($pretype == '02' ) {
				$theCSS .= '.loader02 {width: 56px;height: 56px;border: 8px solid rgba('.$spin_rgb.', 0.25);border-top-color: '.$spinclr.';border-radius: 50%;position: relative;animation: loader-rotate 1s linear infinite;top: 50%;margin: -28px auto 0; }@keyframes loader-rotate {0% {transform: rotate(0); }100% {transform: rotate(360deg); } }';
			}
			if ( $pretype == '03' ) {
				$theCSS .= '.loader03 {width: 56px;height: 56px;border: 8px solid transparent;border-top-color: '.$spinclr.';border-bottom-color: '.$spinclr.';border-radius: 50%;position: relative;animation: loader-rotate 1s linear infinite;top: 50%;margin: -28px auto 0; }@keyframes loader-rotate {0% {transform: rotate(0); }100% {transform: rotate(360deg); } }';
			}
			if ( $pretype == '04' ) {
				$theCSS .= '.loader04 {width: 56px;height: 56px;border: 2px solid rgba('.$spin_rgb.', 0.5);border-radius: 50%;position: relative;animation: loader-rotate 1s ease-in-out infinite;top: 50%;margin: -28px auto 0; }.loader04::after {content: \'\';width: 10px;height: 10px;border-radius: 50%;background: '.$spinclr.';position: absolute;top: -6px;left: 50%;margin-left: -5px; }@keyframes loader-rotate {0% {transform: rotate(0); }100% {transform: rotate(360deg); } }';
			}
			if ( $pretype == '05' ) {
				$theCSS .= '.loader05 {width: 56px;height: 56px;border: 4px solid '.$spinclr.';border-radius: 50%;position: relative;animation: loader-scale 1s ease-out infinite;top: 50%;margin: -28px auto 0; }@keyframes loader-scale {0% {transform: scale(0);opacity: 0; }50% {opacity: 1; }100% {transform: scale(1);opacity: 0; } }';
			}
			if ( $pretype == '06' ) {
				$theCSS .= '.loader06 {width: 56px;height: 56px;border: 4px solid transparent;border-radius: 50%;position: relative;top: 50%;margin: -28px auto 0; }.loader06::before {content:  \'\';border: 4px solid rgba('.$spin_rgb.', 0.5);border-radius: 50%;width: 67.2px;height: 67.2px;position: absolute;top: -9.6px;left: -9.6px;animation: loader-scale 1s ease-out infinite;animation-delay: 1s;opacity: 0; }.loader06::after {content:  \'\';border: 4px solid '.$spinclr.';border-radius: 50%;width: 56px;height: 56px;position: absolute;top: -4px;left: -4px;animation: loader-scale 1s ease-out infinite;animation-delay: 0.5s; }@keyframes loader-scale {0% {transform: scale(0);opacity: 0; }50% {opacity: 1; }100% {transform: scale(1);opacity: 0; } }';
			}
			if ( $pretype == '07' ) {
				$theCSS .= '.loader07 {width: 16px;height: 16px;border-radius: 50%;position: relative;animation: loader-circles 1s linear infinite;top: 50%;margin: -8px auto 0; }@keyframes loader-circles {0% {box-shadow: 0 -27px 0 0 rgba('.$spin_rgb.', 0.05), 19px -19px 0 0 rgba('.$spin_rgb.', 0.1), 27px 0 0 0 rgba('.$spin_rgb.', 0.2), 19px 19px 0 0 rgba('.$spin_rgb.', 0.3), 0 27px 0 0 rgba('.$spin_rgb.', 0.4), -19px 19px 0 0 rgba('.$spin_rgb.', 0.6), -27px 0 0 0 rgba('.$spin_rgb.', 0.8), -19px -19px 0 0 '.$spinclr.'; }12.5% {box-shadow: 0 -27px 0 0 '.$spinclr.', 19px -19px 0 0 rgba('.$spin_rgb.', 0.05), 27px 0 0 0 rgba('.$spin_rgb.', 0.1), 19px 19px 0 0 rgba('.$spin_rgb.', 0.2), 0 27px 0 0 rgba('.$spin_rgb.', 0.3), -19px 19px 0 0 rgba('.$spin_rgb.', 0.4), -27px 0 0 0 rgba('.$spin_rgb.', 0.6), -19px -19px 0 0 rgba('.$spin_rgb.', 0.8); }25% {box-shadow: 0 -27px 0 0 rgba('.$spin_rgb.', 0.8), 19px -19px 0 0 '.$spinclr.', 27px 0 0 0 rgba('.$spin_rgb.', 0.05), 19px 19px 0 0 rgba('.$spin_rgb.', 0.1), 0 27px 0 0 rgba('.$spin_rgb.', 0.2), -19px 19px 0 0 rgba('.$spin_rgb.', 0.3), -27px 0 0 0 rgba('.$spin_rgb.', 0.4), -19px -19px 0 0 rgba('.$spin_rgb.', 0.6); }37.5% {box-shadow: 0 -27px 0 0 rgba('.$spin_rgb.', 0.6), 19px -19px 0 0 rgba('.$spin_rgb.', 0.8), 27px 0 0 0 '.$spinclr.', 19px 19px 0 0 rgba('.$spin_rgb.', 0.05), 0 27px 0 0 rgba('.$spin_rgb.', 0.1), -19px 19px 0 0 rgba('.$spin_rgb.', 0.2), -27px 0 0 0 rgba('.$spin_rgb.', 0.3), -19px -19px 0 0 rgba('.$spin_rgb.', 0.4); }50% {box-shadow: 0 -27px 0 0 rgba('.$spin_rgb.', 0.4), 19px -19px 0 0 rgba('.$spin_rgb.', 0.6), 27px 0 0 0 rgba('.$spin_rgb.', 0.8), 19px 19px 0 0 '.$spinclr.', 0 27px 0 0 rgba('.$spin_rgb.', 0.05), -19px 19px 0 0 rgba('.$spin_rgb.', 0.1), -27px 0 0 0 rgba('.$spin_rgb.', 0.2), -19px -19px 0 0 rgba('.$spin_rgb.', 0.3); }62.5% {box-shadow: 0 -27px 0 0 rgba('.$spin_rgb.', 0.3), 19px -19px 0 0 rgba('.$spin_rgb.', 0.4), 27px 0 0 0 rgba('.$spin_rgb.', 0.6), 19px 19px 0 0 rgba('.$spin_rgb.', 0.8), 0 27px 0 0 '.$spinclr.', -19px 19px 0 0 rgba('.$spin_rgb.', 0.05), -27px 0 0 0 rgba('.$spin_rgb.', 0.1), -19px -19px 0 0 rgba('.$spin_rgb.', 0.2); }75% {box-shadow: 0 -27px 0 0 rgba('.$spin_rgb.', 0.2), 19px -19px 0 0 rgba('.$spin_rgb.', 0.3), 27px 0 0 0 rgba('.$spin_rgb.', 0.4), 19px 19px 0 0 rgba('.$spin_rgb.', 0.6), 0 27px 0 0 rgba('.$spin_rgb.', 0.8), -19px 19px 0 0 '.$spinclr.', -27px 0 0 0 rgba('.$spin_rgb.', 0.05), -19px -19px 0 0 rgba('.$spin_rgb.', 0.1); }87.5% {box-shadow: 0 -27px 0 0 rgba('.$spin_rgb.', 0.1), 19px -19px 0 0 rgba('.$spin_rgb.', 0.2), 27px 0 0 0 rgba('.$spin_rgb.', 0.3), 19px 19px 0 0 rgba('.$spin_rgb.', 0.4), 0 27px 0 0 rgba('.$spin_rgb.', 0.6), -19px 19px 0 0 rgba('.$spin_rgb.', 0.8), -27px 0 0 0 '.$spinclr.', -19px -19px 0 0 rgba('.$spin_rgb.', 0.05); }100% {box-shadow: 0 -27px 0 0 rgba('.$spin_rgb.', 0.05), 19px -19px 0 0 rgba('.$spin_rgb.', 0.1), 27px 0 0 0 rgba('.$spin_rgb.', 0.2), 19px 19px 0 0 rgba('.$spin_rgb.', 0.3), 0 27px 0 0 rgba('.$spin_rgb.', 0.4), -19px 19px 0 0 rgba('.$spin_rgb.', 0.6), -27px 0 0 0 rgba('.$spin_rgb.', 0.8), -19px -19px 0 0 '.$spinclr.'; } }';
			}
			if ( $pretype == '08' ) {
				$theCSS .= '.loader08 {width: 20px;height: 20px;position: relative;animation: loader08 1s ease infinite;top: 50%;margin: -46px auto 0; }@keyframes loader08 {0%, 100% {box-shadow: -13px 20px 0 '.$spinclr.', 13px 20px 0 rgba('.$spin_rgb.', 0.2), 13px 46px 0 rgba('.$spin_rgb.', 0.2), -13px 46px 0 rgba('.$spin_rgb.', 0.2); }25% {box-shadow: -13px 20px 0 rgba('.$spin_rgb.', 0.2), 13px 20px 0 '.$spinclr.', 13px 46px 0 rgba('.$spin_rgb.', 0.2), -13px 46px 0 rgba('.$spin_rgb.', 0.2); }50% {box-shadow: -13px 20px 0 rgba('.$spin_rgb.', 0.2), 13px 20px 0 rgba('.$spin_rgb.', 0.2), 13px 46px 0 '.$spinclr.', -13px 46px 0 rgba('.$spin_rgb.', 0.2); }75% {box-shadow: -13px 20px 0 rgba('.$spin_rgb.', 0.2), 13px 20px 0 rgba('.$spin_rgb.', 0.2), 13px 46px 0 rgba('.$spin_rgb.', 0.2), -13px 46px 0 '.$spinclr.'; } }';
			}
			if ( $pretype == '09' ) {
				$theCSS .= '.loader09 {width: 10px;height: 48px;background: '.$spinclr.';position: relative;animation: loader09 1s ease-in-out infinite;animation-delay: 0.4s;top: 50%;margin: -28px auto 0; }.loader09::after, .loader09::before {content:  \'\';position: absolute;width: 10px;height: 48px;background: '.$spinclr.';animation: loader09 1s ease-in-out infinite; }.loader09::before {right: 18px;animation-delay: 0.2s; }.loader09::after {left: 18px;animation-delay: 0.6s; }@keyframes loader09 {0%, 100% {box-shadow: 0 0 0 '.$spinclr.', 0 0 0 '.$spinclr.'; }50% {box-shadow: 0 -8px 0 '.$spinclr.', 0 8px 0 '.$spinclr.'; } }';
			}
			if ( $pretype == '10' ) {
				$theCSS .= '.loader10 {width: 28px;height: 28px;border-radius: 50%;position: relative;animation: loader10 0.9s ease alternate infinite;animation-delay: 0.36s;top: 50%;margin: -42px auto 0; }.loader10::after, .loader10::before {content:  \'\';position: absolute;width: 28px;height: 28px;border-radius: 50%;animation: loader10 0.9s ease alternate infinite; }.loader10::before {left: -40px;animation-delay: 0.18s; }.loader10::after {right: -40px;animation-delay: 0.54s; }@keyframes loader10 {0% {box-shadow: 0 28px 0 -28px '.$spinclr.'; }100% {box-shadow: 0 28px 0 '.$spinclr.'; } }';
			}
			if ( $pretype == '11' ) {
				$theCSS .= '.loader11 {width: 20px;height: 20px;border-radius: 50%;box-shadow: 0 40px 0 '.$spinclr.';position: relative;animation: loader11 0.8s ease-in-out alternate infinite;animation-delay: 0.32s;top: 50%;margin: -50px auto 0; }.loader11::after, .loader11::before {content:  \'\';position: absolute;width: 20px;height: 20px;border-radius: 50%;box-shadow: 0 40px 0 '.$spinclr.';animation: loader11 0.8s ease-in-out alternate infinite; }.loader11::before {left: -30px;animation-delay: 0.48s;}.loader11::after {right: -30px;animation-delay: 0.16s; }@keyframes loader11 {0% {box-shadow: 0 40px 0 '.$spinclr.'; }100% {box-shadow: 0 20px 0 '.$spinclr.'; } }';
			}
			if ( $pretype == '12' ) {
				$theCSS .= '.loader12 {width: 20px;height: 20px;border-radius: 50%;position: relative;animation: loader12 1s linear alternate infinite;top: 50%;margin: -50px auto 0; }@keyframes loader12 {0% {box-shadow: -60px 40px 0 2px '.$spinclr.', -30px 40px 0 0 rgba('.$spin_rgb.', 0.2), 0 40px 0 0 rgba('.$spin_rgb.', 0.2), 30px 40px 0 0 rgba('.$spin_rgb.', 0.2), 60px 40px 0 0 rgba('.$spin_rgb.', 0.2); }25% {box-shadow: -60px 40px 0 0 rgba('.$spin_rgb.', 0.2), -30px 40px 0 2px '.$spinclr.', 0 40px 0 0 rgba('.$spin_rgb.', 0.2), 30px 40px 0 0 rgba('.$spin_rgb.', 0.2), 60px 40px 0 0 rgba('.$spin_rgb.', 0.2); }50% {box-shadow: -60px 40px 0 0 rgba('.$spin_rgb.', 0.2), -30px 40px 0 0 rgba('.$spin_rgb.', 0.2), 0 40px 0 2px '.$spinclr.', 30px 40px 0 0 rgba('.$spin_rgb.', 0.2), 60px 40px 0 0 rgba('.$spin_rgb.', 0.2); }75% {box-shadow: -60px 40px 0 0 rgba('.$spin_rgb.', 0.2), -30px 40px 0 0 rgba('.$spin_rgb.', 0.2), 0 40px 0 0 rgba('.$spin_rgb.', 0.2), 30px 40px 0 2px '.$spinclr.', 60px 40px 0 0 rgba('.$spin_rgb.', 0.2); }100% {box-shadow: -60px 40px 0 0 rgba('.$spin_rgb.', 0.2), -30px 40px 0 0 rgba('.$spin_rgb.', 0.2), 0 40px 0 0 rgba('.$spin_rgb.', 0.2), 30px 40px 0 0 rgba('.$spin_rgb.', 0.2), 60px 40px 0 2px '.$spinclr.'; } }';
			}

		} else {
			$theCSS .= '.preloader {width: 100%;height: 100%;position: fixed;top:0;left:0;background-color: '.$prebg.';z-index: 9999;}';
		}
	}

	$page_id = get_the_ID();

	/*************************************************
	## THEME GENERAL COLOR SETTINGS
	*************************************************/

	if ( is_404() ) { // error page
		$name = 'error';
	} elseif ( is_archive() ) { // blog and cpt archive page
		$name = 'archive';
	} elseif ( is_search() ) { // search page
		$name = 'search';
	} elseif ( is_home() OR is_front_page() ) { // blog post loop page index.php or your choise on settings
		$name = 'blog';
	} elseif ( is_single() ) { // blog post single/singular page
		$name = 'single';
	} elseif ( is_singular("portfolio") ) { // it is cpt and if you want use another clone this condition and add your cpt name as portfolio
		$name = 'portfolio_single';
	} elseif ( is_page() ) {  // default or custom page
		$name	= 'page';
	}

    if ( is_404() ) {
		$id = '404';
	} else {
		$id = $name;
	}
    // nav button border
    $first_btn_brd = isset($softing['nav_btn1_bg']) && !empty($softing['nav_btn1_bg']) ? $softing['nav_btn1_bg']['color'] : '';
    $first_btn_hvr = isset($softing['nav_btn1_hvrbg']) && !empty($softing['nav_btn1_hvrbg']) ? $softing['nav_btn1_hvrbg']['color'] : '';
    $sec_btn_brd = isset($softing['nav_btn2_bg']) && !empty($softing['nav_btn2_bg']) ? $softing['nav_btn2_bg']['color'] : '';
    $sec_btn_hvr = isset($softing['nav_btn2_hvrbg']) && !empty($softing['nav_btn2_hvrbg']) ? $softing['nav_btn2_hvrbg']['color'] : '';

    if( $first_btn_brd != '' ){ $theCSS .= '.nt-site-header .attr-nav > ul > li:first-child > a{ border-color:'.$first_btn_brd.'; }'; }
    if( $first_btn_hvr != '' ){ $theCSS .= '.nt-site-header .attr-nav > ul > li:first-child > a:hover{ border-color:'.$first_btn_hvr.'; }'; }
    if( $sec_btn_brd != '' ){ $theCSS .= '.nt-site-header .attr-nav > ul > li:nth-child(2) > a{ border-color:'.$sec_btn_brd.'; }'; }
    if( $sec_btn_hvr != '' ){ $theCSS .= '.nt-site-header .attr-nav > ul > li:nth-child(2) > a:hover{ border-color:'.$sec_btn_hvr.'; }'; }
	//default hero bg-image
	// hero padding top - bottom

	$h_pt = isset($softing[$name.'_hero_padt']) && !empty($softing[$name.'_hero_padt']) ? $softing[$name.'_hero_padt'] : '';
	$h_pb = isset($softing[$name.'_hero_padb']) && !empty($softing[$name.'_hero_padb']) ? $softing[$name.'_hero_padb'] : '';
	if( $h_pt != '' ){$theCSS .= '#nt-'.$id.' .'. $name .'-hero { padding-top:'.$h_pt.'px; }'; }
	if( $h_pb != '' ){$theCSS .= '#nt-'.$id.' .'. $name .'-hero { padding-bottom:'.$h_pb.'px; }'; }

	// content padding top - bottom
	$cont_pt = isset($softing[$name.'_cont_padt']) && !empty($softing[$name.'_cont_padt']) ? $softing[$name.'_cont_padt'] : '';
	$cont_pb = isset($softing[$name.'_cont_padb']) && !empty($softing[$name.'_cont_padb']) ? $softing[$name.'_cont_padb'] : '';
	if( $cont_pt != '' ){ $theCSS .= '#nt-'.$id.' .nt-theme-inner-container { padding-top:'.$cont_pt.'px; }'; }
	if( $cont_pb != '' ){ $theCSS .= '#nt-'.$id.' .nt-theme-inner-container { padding-bottom:'.$cont_pb.'px; }'; }

	// theme pagination
	$pag_clr = isset($softing['pag_clr']) && !empty($softing['pag_clr']) ? $softing['pag_clr'] : '';
	$pag_hvrclr = isset($softing['pag_hvrclr']) && !empty($softing['pag_hvrclr']) ? $softing['pag_hvrclr'] : '';
	$pag_nclr = isset($softing['pag_nclr']) && !empty($softing['pag_nclr']) ? $softing['pag_nclr'] : '';
	$pag_hvrnclr = isset($softing['pag_hvrnclr']) && !empty($softing['pag_hvrnclr']) ? $softing['pag_hvrnclr'] : '';

	//pagination color
	if( $pag_clr != '' ){ $theCSS .= '.c-pagination-1.-style-outline .c-pagination-1-item .c-pagination-1-link { border-color: '.$pag_clr.'; }.c-pagination-1.-style-default .c-pagination-1-link { background-color: '.$pag_clr.'; }';}
	//pagination active and hover color
	if( $pag_hvrclr != '' ){ $theCSS .= '.c-pagination-1.-style-outline .c-pagination-1-item.active .c-pagination-1-link, .c-pagination-1.-style-outline .c-pagination-1-item .c-pagination-1-link:hover { border-color: '.$pag_hvrclr.'; }.c-pagination-1.-style-default .c-pagination-1-item.active .c-pagination-1-link, .c-pagination-1.-style-default .c-pagination-1-item .c-pagination-1-link:hover { background-color: '.$pag_hvrclr.'; }';}
	//pagination number color
	if( $pag_nclr != '' ){ $theCSS .= '.c-pagination-1.-style-outline .c-pagination-1-item .c-pagination-1-link,.c-pagination-1.-style-default .c-pagination-1-link { color: '.$pag_nclr.'; }';}
	//pagination active and hover color
	if( $pag_hvrnclr != '' ){ $theCSS .= '.c-pagination-1.-style-outline .c-pagination-1-item.active .c-pagination-1-link, .c-pagination-1.-style-outline .c-pagination-1-item .c-pagination-1-link:hover, .c-pagination-1.-style-default .c-pagination-1-item.active .c-pagination-1-link, .c-pagination-1.-style-default .c-pagination-1-item .c-pagination-1-link:hover { color: '.$pag_hvrnclr.'; }';}

	if( is_page() ){

		/*************************************************
		## PAGE METABOX SETTINGS
		*************************************************/


		/*************************************************
		## PAGE HERO OPTIONS
		*************************************************/
		//page hero background image
		$p_hero_bg = rwmb_meta( 'softing_p_h_bg' );
		$p_hero_bg = is_array($p_hero_bg) ? $p_hero_bg : false;
		if ( $p_hero_bg != false || !empty($p_hero_bg['image']) || !empty($p_hero_bg['color']) ) {
		$theCSS .= '#nt-hero.page-id-'. $page_id.'.page-hero {';
		if(!empty($p_hero_bg['image']))	    {$theCSS .= 'background-image:url('.$p_hero_bg['image'].')!important;';}
		if(!empty($p_hero_bg['color']))	    {$theCSS .= 'background-color:'.$p_hero_bg['color'].'!important;';}
		if(!empty($p_hero_bg['size']))		{$theCSS .= 'background-size:'.$p_hero_bg['size'].'!important;';}
		if(!empty($p_hero_bg['repeat']))	{$theCSS .= 'background-repeat:'.$p_hero_bg['repeat'].'!important;';}
		if(!empty($p_hero_bg['position']))	{$theCSS .= 'background-position:'.$p_hero_bg['position'].'!important;';}
		if(!empty($p_hero_bg['attachment'])){$theCSS .= 'background-attachment:'.$p_hero_bg['attachment'].'!important;';}
		$theCSS .= '}';
		//page background image overlay color
		$p_h_o_t = rwmb_meta( 'softing_page_hero_overlay_type' );
		if( $p_h_o_t == 'custom' ){
		$p_h_o = rwmb_meta( 'softing_p_h_overlay' );
		if( $p_h_o != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.'.pattern-black:after,#nt-hero.page-id-'. $page_id.'.pattern-white:after { background:'.$p_h_o.';}'; }
		}
		}
		//page hero padding
		$p_h_pt = rwmb_meta( 'softing_p_h_pt' );
		if( $p_h_pt != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' { padding-top: '.$p_h_pt.'px;}'; }
		$p_h_pb = rwmb_meta( 'softing_p_h_pb' );
		if( $p_h_pb != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' { padding-bottom: '.$p_h_pb.'px;}'; }
		//page hero-title
		$p_t_clr = rwmb_meta( 'softing_p_t_clr' );
		if( $p_t_clr != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' .hero-title { color:'.$p_t_clr.';}'; }
		//page hero-title font-size
		$p_t_fs = rwmb_meta( 'softing_p_t_fs' );
		if( $p_t_fs != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' .hero-title { font-size:'.$p_t_fs.'px;}'; }
		//page hero-title margin-bottom
		$p_t_mb = rwmb_meta( 'softing_p_t_mb' );
		if( $p_t_mb != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' .hero-title { margin-bottom:'.$p_t_mb.'px;}'; }

		//page hero-slogan
		$p_s_clr = rwmb_meta( 'softing_p_s_clr' );
		$p_s_fs = rwmb_meta( 'softing_p_s_fs' );
		if( $p_s_clr != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' .hero-subtitle { color:'.$p_s_clr.';}'; }
		if( $p_s_fs != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' .hero-subtitle { font-size:'.$p_s_fs.'px;}'; }
		//page hero-description
		$p_d_clr = rwmb_meta( 'softing_p_d_clr' );
		$p_d_fs = rwmb_meta( 'softing_p_d_fs' );
		if( $p_d_clr != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' .hero-desc { color:'.$p_d_clr.';}'; }
		if( $p_d_fs != '' ){ $theCSS .= '#nt-hero.page-id-'.$page_id.' .hero-desc { font-size:'.$p_d_fs.'px;}'; }

		/*************************************************
		## PAGE CONTENT SPACING
		*************************************************/
		//page hero padding
		$p_c_pt = rwmb_meta( 'softing_p_c_pt' );
		if( $p_c_pt != '' ){ $theCSS .= '.page-id-'.$page_id.' #nt-page .latest-blog-area{ padding-top: '.$p_c_pt.'px;}'; }
		$p_c_pb = rwmb_meta( 'softing_p_c_pb' );
		if( $p_c_pb != '' ){ $theCSS .= '.page-id-'.$page_id.' #nt-page .latest-blog-area { padding-bottom: '.$p_c_pb.'px;}'; }

		/*************************************************
		## PAGE HEADER/NAVIGATION COLOR
		*************************************************/
		//page navigation on-off
		$p_n_d = rwmb_meta('softing_page_nav_onoff');
		if ( $p_n_d != '0' ) {
		//page navigation bg color
		$p_n_bg = rwmb_meta('softing_page_nav_bgcolor');
		if ( $p_n_bg != '' ) {$theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav{background-color:'.$p_n_bg.' !important;}';}
		//page navigation menu item color
		$p_n_i = rwmb_meta('softing_page_nav_color');
		if ( $p_n_i != '' )  {$theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav ul.nav > li > a {color:'.$p_n_i.' !important;}';}
		//page navigation hover menu item color
		$p_n_i_h = rwmb_meta('softing_page_nav_hovercolor');
		if ( $p_n_i_h != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav ul.nav > li > a:hover{color:'.$p_n_i_h.' !important;}';}
		//page navigation hover menu item bgcolor
		$p_n_i_hbg = rwmb_meta('softing_page_nav_hoverbgcolor');
		if ( $p_n_i_hbg != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav ul.nav > li > a:hover{background-color:'.$p_n_i_hbg.' !important;}';}
		//page navigation padding
		$p_n_pt = rwmb_meta('softing_page_nav_pt');
		if ( $p_n_pt != '' ) { $theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav { padding-top:'.$p_n_pt.' !important; }'; }
		$p_n_pb = rwmb_meta('softing_page_nav_pb');
		if ( $p_n_pb != '' ) { $theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav { padding-bottom:'.$p_n_pb.' !important; }'; }

		//PAGE DROPDOWN SUBMENU
		//page navigation dropdown bg
		$p_sn_bg = rwmb_meta('softing_page_subnav_bg');
		if ( $p_sn_bg != '' ) {$theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav li.dropdown ul.dropdown-menu {background-color:'.$p_sn_bg.' !important;}';}
		//page navigation dropdown min-width
		$p_sn_minw = rwmb_meta('softing_page_subnav_minw');
		if ( $p_sn_minw != '' ) {$theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav li.dropdown ul.dropdown-menu {width:'.$p_sn_minw.'px !important;}';}
		//page navigation dropdown item color
		$p_sn_clr = rwmb_meta('softing_page_subnav_clr');
		if ( $p_sn_clr != '' ) {$theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav ul.nav ul.dropdown-menu > li > a{color:'.$p_sn_clr.'px !important;}';}
		//page navigation dropdown hover color
		$p_sn_hvrclr = rwmb_meta('softing_page_subnav_hvrclr');
		if ( $p_sn_hvrclr != '' ) {$theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav ul.nav ul.dropdown-menu > li > a:hover{color:'.$p_sn_hvrclr.'px !important;}';}
		//page navigation dropdown padding
		$p_sn_p = get_post_meta( $page_id, 'softing_page_subnav_pad' );
		$p_sn_p = is_array($p_sn_p) ? $p_sn_p : false;
		if ( $p_sn_p != false ) {
		if(!empty($p_sn_p[0])){ $theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav li.dropdown ul.dropdown-menu { padding-top:'.$p_sn_p[0].' !important; }'; }
		if(!empty($p_sn_p[1])){ $theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav li.dropdown ul.dropdown-menu { padding-right:'.$p_sn_p[1].' !important; }'; }
		if(!empty($p_sn_p[2])){ $theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav li.dropdown ul.dropdown-menu { padding-bottom:'.$p_sn_p[2].' !important; }'; }
		if(!empty($p_sn_p[3])){ $theCSS .= '.page-id-'.$page_id.' .nt-site-header nav.navbar.bootsnav li.dropdown ul.dropdown-menu { padding-left:'.$p_sn_p[3].' !important; }'; }
		}

		}//end page nav on-off

		/*************************************************
		## PAGE FOOTER
		*************************************************/
		//page footer onoff
		$p_f_d = rwmb_meta('page_footer_onoff');
		if ( $p_f_d != '0' ) {
		//page footer bg color
		$p_f_bg = rwmb_meta('softing_p_f_bg');
		if ( $p_f_bg != '' ) {$theCSS .= '.page-id-'.$page_id.' .nt-footer{background-color:'.$p_f_bg.' !important;}';}
		//page footer-details color
		$p_f_c = rwmb_meta('softing_p_f_c');
		if ( $p_f_c != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-copyright, .page-id-'.$page_id.' .nt-copyright p {color:'.$p_f_c.' !important;}';}
		//page footer section content padding-top
		$p_f_pt = rwmb_meta('softing_p_f_pt');
		if ( $p_f_pt != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-footer {padding-top:'.$p_f_pt.'px !important;}';}
		//page footer section content padding-bottom
		$p_f_pb = rwmb_meta('softing_p_f_pb');
		if ( $p_f_pb != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-footer {padding-bottom:'.$p_f_pb.'px !important;}';}

		}//end if page footer onoff

		/*************************************************
		## PAGE FOOTER WIDGET AREA
		*************************************************/
		//page footer widget area onoff
		$p_fw_d = rwmb_meta('softing_page_fw_onoff');
		if ( $p_fw_d != '0' ) {
		//page footer widget area bg color
		$p_fw_bg = rwmb_meta( 'softing_p_fw_bg' );
		$p_fw_bg = is_array($p_fw_bg) ? $p_fw_bg : false;
		if ( $p_fw_bg != false && !empty($p_fw_bg['image']) ) {
		$theCSS .= '.page-id-'. $page_id.' .nt-footer-sidebar {';
		if(!empty($p_fw_bg['image']))	  {$theCSS .= 'background-image:url('.$p_fw_bg['image'].')!important;';}
		if(!empty($p_fw_bg['color']))	  {$theCSS .= 'background-color:'.$p_fw_bg['color'].'!important;';}
		if(!empty($p_fw_bg['size']))	  {$theCSS .= 'background-size:'.$p_fw_bg['size'].'!important;';}
		if(!empty($p_fw_bg['repeat']))	  {$theCSS .= 'background-repeat:'.$p_fw_bg['repeat'].'!important;';}
		if(!empty($p_fw_bg['position']))  {$theCSS .= 'background-position:'.$p_fw_bg['position'].'!important;';}
		if(!empty($p_fw_bg['attachment'])){$theCSS .= 'background-attachment:'.$p_fw_bg['attachment'].'!important;';}
		$theCSS .= '}';
		//page navigation bg color
		$p_fw_bg_o = rwmb_meta( 'softing_p_fw_bg_o' );
		if( $p_fw_bg_o != '' ){ $theCSS .= '.page-id-'. $page_id.' .nt-footer-sidebar {position:relative}.page-id-'. $page_id.' .nt-footer-sidebar:before { content:"";position:absolute;width:100%;height:100%;top:0;left:0;background-color:'.$p_fw_bg_o.'; }'; }
		}
		//page footer widget area text
		$p_fw_t_c = rwmb_meta('softing_p_fw_t_c');
		if ( $p_fw_t_c != '' )  {$theCSS .= '.page-id-'.$page_id.' .nt-footer-sidebar .footer-widget { color:'.$p_fw_t_c.' !important; }';}
		//page footer widget area widget heading color
		$p_fw_h_c = rwmb_meta('softing_p_fw_h_c');
		if ( $p_fw_h_c != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-footer-sidebar .footer-widget h3 { color:'.$p_fw_h_c.' !important; }';}
		//page footer widget area link color
		$p_fw_a = rwmb_meta('softing_p_fw_a');
		if ( $p_fw_a != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-footer-sidebar .footer-widget a { color:'.$p_fw_a.' !important; }';}
		//page footer widget area hover link color
		$p_fw_hvra = rwmb_meta('softing_p_fw_hvra');
		if ( $p_fw_hvra != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-footer-sidebar .footer-widget a:hover { color:'.$p_fw_hvra.' !important; }';}
		//page footer widget area padding-top
		$p_fw_pt = rwmb_meta('softing_p_fw_pt');
		if ( $p_fw_pt != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-footer-sidebar { padding-top:'.$p_fw_pt.'px !important; }';}
		//page footer section content padding-bottom
		$p_fw_pb = rwmb_meta('softing_p_fw_pb');
		if ( $p_fw_pb != '' ){$theCSS .= '.page-id-'.$page_id.' .nt-footer-sidebar {padding-bottom:'.$p_fw_pb.'px !important; }';}
		}//end if page footer widget area onoff

	}//end if is_page


	wp_register_style( 'softing-custom-style', false );
	wp_enqueue_style( 'softing-custom-style' );

    /* Add CSS to style.css */
    wp_add_inline_style( 'softing-custom-style', $theCSS );
	}

add_action( 'wp_enqueue_scripts', 'softing_custom_css' );


// customization on admin pages
function softing_admin_custom_css() {

if (  ! is_admin() )
return false;

/* CSS to output */
$theCSS = '';

$theCSS .= '

    #setting-error-tgmpa, #setting-error-softing {display: block !important;}

    .updated.vc_license-activation-notice {display:none;}

    .rwmb-tab-panel .rwmb-thickbox_image-wrapper ul li {
    	display: inline-block;
        position: relative;
    }

    .rwmb-image-item .rwmb-media-preview {
        width: 150px;
        background: #eee;
    }

    .wpb_vc_row {
        position: relative;
    }

    .wpb_element_wrapper {
        padding-top: 27px;
    }

    .wpb_vc_row >.wpb_element_wrapper>.vc_admin_label {
    	font-size: 12px;
        font-style: italic;
        color: #fff;
        line-height: 24px;
        background: #0473aa;
        position: absolute;
        top: 27px;
        right: -5px;
        pointer-events: none;
        padding: 0 7px;
    }

    .wpb_vc_row >.wpb_element_wrapper>.vc_admin_label:hover:before {
    	opacity:1;
    }

    .vc_license-activation-notice {
        display: none!important;
    }

    .vc_admin_label {
        font-weight: 500;
    }

    .vc_btn3-container .vc_general.vc_btn3{
    	display: inline-block;
    	font-size: 14px;
    	font-weight: 600;
    	line-height: 25px;
    	text-transform: uppercase;
    	-webkit-transition: all 0.35s ease-in-out;
    	-moz-transition: all 0.35s ease-in-out;
    	-ms-transition: all 0.35s ease-in-out;
    	-o-transition: all 0.35s ease-in-out;
    	transition: all 0.35s ease-in-out;
    	font-weight: 700;
    	letter-spacing: 1px;
    	-webkit-border-radius: 5px;
    	-moz-border-radius: 5px;
    	border-radius: 5px;
    	overflow: hidden;
    	-webkit-border-radius: 30px!important;
    	-moz-border-radius: 30px!important;
    	border-radius: 30px!important;
    }

    .vc_btn3-container .vc_btn3-style-border{
    	background-color: transparent!important;
    	color: #4ac4f3 !important;
    	border: 2px solid #4ac4f3!important;
    }
    .vc_btn3-container .vc_btn3-style-effect{
    	background-color: #4ac4f3 !important;
    	color: #fff !important;
    	border: none!important;
    }
    .vc_btn3-container .vc_btn3-style-effect{
    	background-color: #4ac4f3 !important;
    	color: #fff !important;
    	border: none!important;
    }
    .vc_btn3-container .vc_btn3-style-border.vc_btn3-size-lg, .vc_btn3-container .vc_btn3-style-effect.vc_btn3-size-lg {
    	padding: 12px 80px!important;
    	font-size: 16px!important;
    }
    .vc_btn3-container .vc_btn3-style-border.vc_btn3-size-md, .vc_btn3-container .vc_btn3-style-effect.vc_btn3-size-md {
    	padding: padding: 10px 40px!important;
    	font-size: 14px!important;
    }
    .vc_btn3-container .vc_btn3-style-border.vc_btn3-size-sm, .vc_btn3-container .vc_btn3-style-effect.vc_btn3-size-sm {
    	padding: 8px 35px!important;
    	font-size: 12px!important;
    }
    .vc_btn3-container .vc_btn3-style-border.vc_btn3-size-xs, .vc_btn3-container .vc_btn3-style-effect.vc_btn3-size-xs {
    	padding: 6px 30px!important;
    	font-size: 10px!important;
    }

    .rwmb-tab-nav {
        margin-bottom: 22px !important;
    }
    .rwmb-tab-nav .rwmb-tab-active {
        border: 1px solid #0073aa !important;
        border-bottom-color: transparent !important;
        background: #0073aa !important;
        padding: 2px 10px !important;
    }
    .rwmb-tab-active a {
        color: #fff !important;
    }
    .rwmb-tab-panel {
      padding: 25px 11px !important;
    }
    .rwmb-label {
        width: 25%;
        margin-right: 10% !important;
    }
    .rwmb-label ~ .rwmb-input {
        width: 65% !important;
    }
    .rwmb-text_list-non-cloneable:not(.default-column) > .rwmb-input > label, .rwmb-text_list-clone > label {
        width: 47%;
    }
    .rwmb-text_list-non-cloneable:not(.default-column) > .rwmb-input > label > input, .rwmb-text_list-clone > label > input {
        width: 100%;
    }
    .rwmb-text_list-non-cloneable p {
        width: 100%;
    }
    .rwmb-field.rwmb-sidebar-wrapper .rwmb-inline li{ margin-bottom:10px;}
    div.nt-page-info {
        padding: 15px;
        background: #e9e9e9;
        font-size: 16px;
        font-weight: 600;
        color: #222;
        border-left: 4px solid #E91E63;
    }
    div.nt-page-info > span.dashicons {
        margin-right: 15px;
    }
    .vc_col-xs-12.wpb_el_type_softing_new_param.vc_wrapper-param-type-softing_new_param.vc_shortcode-param.vc_column {
        border-bottom: 1px solid;
        padding: 7px 0px;
        width: 94%;
        margin: 0 auto;
        font-size: 16px;
        font-weight: 900;
        margin-bottom: 20px;
    	margin-top: 15px;
    }
    body .pt15.vc_shortcode-param.vc_column {
        padding-top: 15px!important;
    }
    .nt-divider {
        background-image: url('.get_template_directory_uri().'/vc_templates/divider/base_bg.jpg);
        background-color: #fff;
        height: 130px;
        overflow: hidden;
        border: 1px solid #eee;
    }
    .nt-divider img {
        max-width: 100%;
        width: 100%;
        height: 130px;
    }
    .wpb_el_type_nt_spacer.vc_wrapper-param-type-nt_spacer {
        padding: 8px 8px 4px 8px!important;
        text-align: center;
        font-size: 16px;
        font-weight: bold;
        background: #0473aa;
        color: #fff;
        margin: 15px;
    }
    .redux_field_th {
        color: #191919;
        font-weight: 700;
    }
    .redux-main .description {
        display: block;
    	font-weight: normal;
    }
    #customize-controls img {
        max-width: 75%;
    }
';

    wp_register_style( 'softing-admin-custom-style', false );
    wp_enqueue_style( 'softing-admin-custom-style' );

    /* Add CSS to style.css */
    wp_add_inline_style( 'softing-admin-custom-style', $theCSS );
}

add_action( 'admin_enqueue_scripts', 'softing_admin_custom_css' );
