<?php

	get_header(); // this function content and settings in includes/templat-part.php

	$softing_404_layout = isset($softing['error_layout']) && $softing['error_layout'] != '' ? $softing['error_layout'] : 'full-width';
	$softing_404_layout_ctrl = ( $softing_404_layout == 'left-sidebar' OR $softing_404_layout == 'right-sidebar' ) ? 'col-lg-8' : 'col-lg-12' ; // sidebar setting
	$softing_404_sidebar = ( $softing_404_layout == 'left-sidebar' OR $softing_404_layout == 'right-sidebar' ) ? ' has-sidebar '.$softing_404_layout : ' no-sidebar '.$softing_404_layout;
	$softing_404_hero_off = isset($softing['error_hero']) && $softing['error_hero'] == '0' ? ' hero-off' : '';

	do_action("softing_before_404"); // you can use this action for add any content before container element

?>

<!-- 404 Page General -->
<div id="nt-404" class="nt-404">

	<!-- Hero Section -->
	<?php softing_hero_section(); //this function using on all inner pages ?>

	<!-- Error Content -->
	<div class="nt-theme-inner-container error-page-area bg-gray text-center default-padding<?php echo esc_attr( $softing_404_sidebar.$softing_404_hero_off ); ?>">
		<!-- Section Content -->
		<div class="container">
			<!-- Row -->
			<div class="row">

				<!-- left sidebar -->
				<?php if( $softing_404_layout == 'left-sidebar' ) { get_sidebar(); } ?>

				<!-- Content -->
				<?php if (  is_active_sidebar( 'sidebar-1' )  ) { ?>
				<div class="<?php echo esc_attr( $softing_404_layout_ctrl ); ?>">
				<?php } else { ?>
				<div class="col-lg-12 col-md-12">
				<?php } ?>


					<h1><?php esc_html_e( '404', 'softing' ); ?></h1>
					<h2><?php esc_html_e( 'SORRY PAGE WAS NOT FOUND!', 'softing' ); ?></h2>
					<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try a search?', 'softing' ); ?></p>

					<?php get_search_form(); ?>


				</div><!-- End sidebar + content -->

				<!-- Right sidebar -->
				<?php if( $softing_404_layout == 'right-sidebar' || $softing_404_layout == '' ){  get_sidebar(); } ?>

			</div>
			<!-- Row -->
		</div>
		<!-- End Section Content -->
	</div>
	<!-- End Error Content -->
</div>
<!-- End 404 Page General -->

<?php

	do_action("softing_after_404");

	get_footer();

?>
